/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher.gui;

import com.xerox.amazonws.ec2.EC2Exception;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.xml.bind.JAXBException;
import org.jets3t.service.S3ServiceException;
import org.jvnet.hudson.ec2.launcher.gui.CompletionUpdater;
import org.jvnet.hudson.ec2.launcher.gui.Page;
import org.jvnet.hudson.ec2.launcher.gui.WizardState;
import org.pietschy.wizard.InvalidStateException;

public class StartPage
extends Page {
    private JRadioButton loginToEC2AccountRadioButton;
    private JRadioButton createANewEC2RadioButton;
    private JTextField accessId;
    private JPasswordField secretKey;
    private JPanel panel;
    private JCheckBox rememberPassword;
    private static final String PREFKEY_ACCESSID = "accessId";
    private static final String PREFKEY_SECRETKEY = "secretKey";

    public StartPage(WizardState state) {
        super(state);
        this.$$$setupUI$$$();
        this.add(this.panel);
        new CompletionUpdater(){

            public void update() {
                StartPage.this.accessId.setEnabled(StartPage.this.loginToEC2AccountRadioButton.isSelected());
                StartPage.this.secretKey.setEnabled(StartPage.this.loginToEC2AccountRadioButton.isSelected());
                StartPage.this.setComplete(StartPage.this.loginToEC2AccountRadioButton.isSelected() && this.has(StartPage.this.accessId) && this.has(StartPage.this.secretKey));
            }
        }.add(this.loginToEC2AccountRadioButton).add(this.accessId).add(this.secretKey).update();
        this.accessId.setText(state.prefs.get(PREFKEY_ACCESSID, ""));
        String pwd = state.prefs.get(PREFKEY_SECRETKEY, "");
        this.secretKey.setText(pwd);
        this.rememberPassword.setSelected(pwd.length() > 0);
    }

    public void applyState() throws InvalidStateException {
        try {
            this.busyCursor();
            String id = this.accessId.getText();
            if (id.length() != 20) {
                throw new InvalidStateException("Incorrect access ID. Its length is supposed to be 20 chars");
            }
            String password = new String(this.secretKey.getPassword());
            if (password.length() != 40) {
                throw new InvalidStateException("Incorrect secret key. Its length is supposed to be 40 chars");
            }
            this.state.setCredential(id, password);
            this.state.prefs.put(PREFKEY_ACCESSID, id);
            if (this.rememberPassword.isSelected()) {
                this.state.prefs.put(PREFKEY_SECRETKEY, password);
            } else {
                this.state.prefs.put(PREFKEY_SECRETKEY, "");
            }
        }
        catch (EC2Exception e) {
            this.reportError("Operations on EC2 failed", e);
            throw new InvalidStateException();
        }
        catch (JAXBException e) {
            this.reportError("Failed to load storage information", e);
            throw new InvalidStateException();
        }
        catch (S3ServiceException e) {
            this.reportError("Operations on S3 failed", e);
            throw new InvalidStateException();
        }
        finally {
            this.restoreCursor();
        }
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.loginToEC2AccountRadioButton = new JRadioButton();
        this.loginToEC2AccountRadioButton.setSelected(true);
        this.loginToEC2AccountRadioButton.setText("Login to EC2 account");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.panel.add((Component)this.loginToEC2AccountRadioButton, gbc);
        this.createANewEC2RadioButton = new JRadioButton();
        this.createANewEC2RadioButton.setEnabled(false);
        this.createANewEC2RadioButton.setText("Create a new EC2 account");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.panel.add((Component)this.createANewEC2RadioButton, gbc);
        this.accessId = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.accessId, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 99.0;
        gbc.fill = 3;
        this.panel.add((Component)spacer1, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Access Id: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 13;
        this.panel.add((Component)label1, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Secret Key: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 13;
        this.panel.add((Component)label2, gbc);
        this.secretKey = new JPasswordField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.secretKey, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 99.0;
        gbc.fill = 2;
        this.panel.add((Component)spacer2, gbc);
        JLabel label3 = new JLabel();
        label3.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.ipadx = 32;
        this.panel.add((Component)label3, gbc);
        this.rememberPassword = new JCheckBox();
        this.rememberPassword.setText("Remember the secret key");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.panel.add((Component)this.rememberPassword, gbc);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.loginToEC2AccountRadioButton);
        buttonGroup.add(this.createANewEC2RadioButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

