/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.artifact.deployer;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

@Component(role=ArtifactDeployer.class, hint="maven2")
public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    @Requirement
    private WagonManager wagonManager;
    @Requirement(hint="maven2")
    private ArtifactTransformationManager transformationManager;
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;

    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.deploy(source, artifact, deploymentRepository, localRepository);
    }

    public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        boolean useArtifactFile = false;
        File oldArtifactFile = artifact.getFile();
        if ("pom".equals(artifact.getType())) {
            artifact.setFile(source);
            useArtifactFile = true;
        }
        try {
            File artifactFile;
            this.transformationManager.transformForDeployment(artifact, deploymentRepository, localRepository);
            if (useArtifactFile) {
                source = artifact.getFile();
                artifact.setFile(oldArtifactFile);
            }
            if (!(artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact))).equals(source)) {
                FileUtils.copyFile((File)source, (File)artifactFile);
            }
            TransferListener downloadMonitor = new TransferListener(){

                public void transferInitiated(TransferEvent transferEvent) {
                    String message = transferEvent.getRequestType() == 6 ? "Uploading" : "Downloading";
                    String url = transferEvent.getWagon().getRepository().getUrl();
                    System.out.println(message + ": " + url + "/" + transferEvent.getResource().getName());
                }

                public void transferStarted(TransferEvent transferEvent) {
                }

                public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
                }

                public void transferCompleted(TransferEvent transferEvent) {
                    long contentLength = transferEvent.getResource().getContentLength();
                    if (contentLength != -1L) {
                        String type = transferEvent.getRequestType() == 6 ? "uploaded" : "downloaded";
                        String l = contentLength >= 1024L ? contentLength / 1024L + "K" : contentLength + "b";
                        System.out.println(l + " " + type);
                    }
                }

                public void transferError(TransferEvent transferEvent) {
                    transferEvent.getException().printStackTrace();
                }

                public void debug(String message) {
                }
            };
            this.wagonManager.putArtifact(source, artifact, deploymentRepository, downloadMonitor);
            for (ArtifactMetadata metadata : artifact.getMetadataList()) {
                this.repositoryMetadataManager.deploy(metadata, localRepository, deploymentRepository);
            }
        }
        catch (TransferFailedException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryMetadataDeploymentException e) {
            throw new ArtifactDeploymentException("Error installing artifact's metadata: " + e.getMessage(), (Throwable)e);
        }
    }
}

