/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.event;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class IvyEvent {
    private Ivy _source;
    private String _name;
    private Map _attributes = new HashMap();

    protected IvyEvent(Ivy source, String name) {
        this._source = source;
        this._name = name;
    }

    protected void addAttribute(String key, String value) {
        this._attributes.put(key, value);
    }

    protected void addMDAttributes(ModuleDescriptor md) {
        this.addMridAttributes(md.getResolvedModuleRevisionId());
    }

    protected void addMridAttributes(ModuleRevisionId mrid) {
        this.addModuleIdAttributes(mrid.getModuleId());
        this.addAttribute("revision", mrid.getRevision());
        this.addAttributes(mrid.getExtraAttributes());
    }

    protected void addModuleIdAttributes(ModuleId moduleId) {
        this.addAttribute("organisation", moduleId.getOrganisation());
        this.addAttribute("module", moduleId.getName());
    }

    protected void addConfsAttribute(String[] confs) {
        this.addAttribute("conf", StringUtils.join(confs, ", "));
    }

    protected void addAttributes(Map attributes) {
        this._attributes.putAll(attributes);
    }

    public Ivy getSource() {
        return this._source;
    }

    public String getName() {
        return this._name;
    }

    public Map getAttributes() {
        return new HashMap(this._attributes);
    }

    public String toString() {
        return this.getName() + " " + this.getAttributes();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IvyEvent)) {
            return false;
        }
        IvyEvent e = (IvyEvent)obj;
        return this.getSource().equals(e.getSource()) && this.getName().equals(e.getName()) && ((Object)this._attributes).equals(e._attributes);
    }

    public int hashCode() {
        int hash = 37;
        hash = 13 * hash + this.getSource().hashCode();
        hash = 13 * hash + this.getName().hashCode();
        hash = 13 * hash + ((Object)this._attributes).hashCode();
        return hash;
    }
}

