/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.event.download;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactOrigin;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.event.download.DownloadEvent;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import java.io.File;

public class EndArtifactDownloadEvent
extends DownloadEvent {
    public static final String NAME = "post-download-artifact";
    private DependencyResolver _resolver;
    private ArtifactDownloadReport _report;

    public EndArtifactDownloadEvent(Ivy source, DependencyResolver resolver, Artifact artifact, ArtifactDownloadReport report, File dest) {
        super(source, NAME, artifact);
        this._resolver = resolver;
        this._report = report;
        this.addAttribute("resolver", this._resolver.getName());
        this.addAttribute("status", this._report.getDownloadStatus().toString());
        this.addAttribute("size", String.valueOf(this._report.getSize()));
        this.addAttribute("file", dest.getAbsolutePath());
        ArtifactOrigin origin = report.getArtifactOrigin();
        if (origin != null) {
            this.addAttribute("origin", this._report.getArtifactOrigin().getLocation());
            this.addAttribute("local", String.valueOf(this._report.getArtifactOrigin().isLocal()));
        } else {
            this.addAttribute("origin", "");
            this.addAttribute("local", "");
        }
    }

    public ArtifactDownloadReport getReport() {
        return this._report;
    }

    public DependencyResolver getResolver() {
        return this._resolver;
    }
}

