/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.version;

import fr.jayasoft.ivy.ArtifactInfo;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyAware;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.version.AbstractVersionMatcher;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionRangeMatcher
extends AbstractVersionMatcher
implements IvyAware {
    private static final String OPEN_INC = "[";
    private static final String OPEN_EXC = "]";
    private static final String CLOSE_INC = "]";
    private static final String CLOSE_EXC = "[";
    private static final String LOWER_INFINITE = "(";
    private static final String UPPER_INFINITE = ")";
    private static final String SEPARATOR = ",";
    private static final String OPEN_INC_PATTERN = "\\[";
    private static final String OPEN_EXC_PATTERN = "\\]";
    private static final String CLOSE_INC_PATTERN = "\\]";
    private static final String CLOSE_EXC_PATTERN = "\\[";
    private static final String LI_PATTERN = "\\(";
    private static final String UI_PATTERN = "\\)";
    private static final String SEP_PATTERN = "\\,";
    private static final String OPEN_PATTERN = "[\\[\\]]";
    private static final String CLOSE_PATTERN = "[\\]\\[]";
    private static final String ANY_NON_SPECIAL_PATTERN = "[^\\,\\[\\]\\]\\[\\(\\)]";
    private static final String FINITE_PATTERN = "[\\[\\]]([^\\,\\[\\]\\]\\[\\(\\)]+)\\,([^\\,\\[\\]\\]\\[\\(\\)]+)[\\]\\[]";
    private static final String LOWER_INFINITE_PATTERN = "\\(\\,([^\\,\\[\\]\\]\\[\\(\\)]+)[\\]\\[]";
    private static final String UPPER_INFINITE_PATTERN = "[\\[\\]]([^\\,\\[\\]\\]\\[\\(\\)]+)\\,\\)";
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]]([^\\,\\[\\]\\]\\[\\(\\)]+)\\,([^\\,\\[\\]\\]\\[\\(\\)]+)[\\]\\[]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\,([^\\,\\[\\]\\]\\[\\(\\)]+)[\\]\\[]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]]([^\\,\\[\\]\\]\\[\\(\\)]+)\\,\\)");
    private static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]]([^\\,\\[\\]\\]\\[\\(\\)]+)\\,([^\\,\\[\\]\\]\\[\\(\\)]+)[\\]\\[]|\\(\\,([^\\,\\[\\]\\]\\[\\(\\)]+)[\\]\\[]|[\\[\\]]([^\\,\\[\\]\\]\\[\\(\\)]+)\\,\\)");
    private final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            MRIDArtifactInfo art1 = new MRIDArtifactInfo((ModuleRevisionId)o1);
            MRIDArtifactInfo art2 = new MRIDArtifactInfo((ModuleRevisionId)o2);
            ArtifactInfo art = VersionRangeMatcher.this.getLatestStrategy().findLatest(new ArtifactInfo[]{art1, art2}, null);
            return art == art1 ? -1 : 1;
        }
    };
    private LatestStrategy _latestStrategy;
    private String _latestStrategyName = "default";

    public VersionRangeMatcher() {
        super("version-range");
    }

    public VersionRangeMatcher(String name) {
        super(name);
    }

    public VersionRangeMatcher(String name, LatestStrategy strategy) {
        super(name);
        this._latestStrategy = strategy;
    }

    public VersionRangeMatcher(String name, Ivy ivy) {
        super(name);
        this.setIvy(ivy);
    }

    public boolean isDynamic(ModuleRevisionId askedMrid) {
        return ALL_RANGE.matcher(askedMrid.getRevision()).matches();
    }

    public boolean accept(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        String revision = askedMrid.getRevision();
        Matcher m = FINITE_RANGE.matcher(revision);
        if (m.matches()) {
            String lower = m.group(1);
            String upper = m.group(2);
            return this.isUpper(askedMrid, lower, foundMrid, revision.startsWith("[")) && this.isLower(askedMrid, upper, foundMrid, revision.endsWith("]"));
        }
        m = LOWER_INFINITE_RANGE.matcher(revision);
        if (m.matches()) {
            String upper = m.group(1);
            return this.isLower(askedMrid, upper, foundMrid, revision.endsWith("]"));
        }
        m = UPPER_INFINITE_RANGE.matcher(revision);
        if (m.matches()) {
            String lower = m.group(1);
            return this.isUpper(askedMrid, lower, foundMrid, revision.startsWith("["));
        }
        return false;
    }

    private boolean isLower(ModuleRevisionId askedMrid, String revision, ModuleRevisionId foundMrid, boolean inclusive) {
        return this.COMPARATOR.compare(ModuleRevisionId.newInstance(askedMrid, revision), foundMrid) <= (inclusive ? 0 : -1);
    }

    private boolean isUpper(ModuleRevisionId askedMrid, String revision, ModuleRevisionId foundMrid, boolean inclusive) {
        return this.COMPARATOR.compare(ModuleRevisionId.newInstance(askedMrid, revision), foundMrid) >= (inclusive ? 0 : 1);
    }

    public LatestStrategy getLatestStrategy() {
        if (this._latestStrategy == null) {
            if (this.getIvy() == null) {
                throw new IllegalStateException("no ivy instance nor latest strategy configured in version range matcher " + this);
            }
            if (this._latestStrategyName == null) {
                throw new IllegalStateException("null latest strategy defined in version range matcher " + this);
            }
            this._latestStrategy = this.getIvy().getLatestStrategy(this._latestStrategyName);
            if (this._latestStrategy == null) {
                throw new IllegalStateException("unknown latest strategy '" + this._latestStrategyName + "' configured in version range matcher " + this);
            }
        }
        return this._latestStrategy;
    }

    public void setLatestStrategy(LatestStrategy latestStrategy) {
        this._latestStrategy = latestStrategy;
    }

    public void setLatest(String latestStrategyName) {
        this._latestStrategyName = latestStrategyName;
    }

    private final class MRIDArtifactInfo
    implements ArtifactInfo {
        private ModuleRevisionId _mrid;

        public MRIDArtifactInfo(ModuleRevisionId id) {
            this._mrid = id;
        }

        public long getLastModified() {
            return 0L;
        }

        public String getRevision() {
            return this._mrid.getRevision();
        }
    }
}

