/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.Enumeration;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class Browser
extends JFrame
implements ServiceListener,
ServiceTypeListener,
ListSelectionListener {
    private static final long serialVersionUID = 5750114542524415107L;
    JmDNS jmdns;
    String type;
    DefaultListModel types;
    JList typeList;
    DefaultListModel services;
    JList serviceList;
    JTextArea info;

    Browser(JmDNS jmDNS) throws IOException {
        super("JmDNS Browser");
        this.jmdns = jmDNS;
        Color color = new Color(230, 230, 230);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 3));
        this.types = new DefaultListModel();
        this.typeList = new JList(this.types);
        this.typeList.setBorder(emptyBorder);
        this.typeList.setBackground(color);
        this.typeList.setSelectionMode(0);
        this.typeList.addListSelectionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", new JLabel("Types"));
        jPanel.add("Center", new JScrollPane(this.typeList, 20, 30));
        container.add(jPanel);
        this.services = new DefaultListModel();
        this.serviceList = new JList(this.services);
        this.serviceList.setBorder(emptyBorder);
        this.serviceList.setBackground(color);
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", new JLabel("Services"));
        jPanel2.add("Center", new JScrollPane(this.serviceList, 20, 30));
        container.add(jPanel2);
        this.info = new JTextArea();
        this.info.setBorder(emptyBorder);
        this.info.setBackground(color);
        this.info.setEditable(false);
        this.info.setLineWrap(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", new JLabel("Details"));
        jPanel3.add("Center", new JScrollPane(this.info, 20, 30));
        container.add(jPanel3);
        this.setDefaultCloseOperation(3);
        this.setLocation(100, 100);
        this.setSize(600, 400);
        jmDNS.addServiceTypeListener(this);
        String[] stringArray = new String[]{"_http._tcp.local.", "_ftp._tcp.local.", "_tftp._tcp.local.", "_ssh._tcp.local.", "_smb._tcp.local.", "_printer._tcp.local.", "_airport._tcp.local.", "_afpovertcp._tcp.local.", "_ichat._tcp.local.", "_eppc._tcp.local.", "_presence._tcp.local.", "_rfb._tcp.local.", "_daap._tcp.local.", "_touchcs._tcp.local."};
        for (int i = 0; i < stringArray.length; ++i) {
            jmDNS.registerServiceType(stringArray[i]);
        }
        this.setVisible(true);
    }

    public void serviceAdded(ServiceEvent serviceEvent) {
        final String string = serviceEvent.getName();
        System.out.println("ADD: " + string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Browser.this.insertSorted(Browser.this.services, string);
            }
        });
    }

    public void serviceRemoved(ServiceEvent serviceEvent) {
        final String string = serviceEvent.getName();
        System.out.println("REMOVE: " + string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Browser.this.services.removeElement(string);
            }
        });
    }

    public void serviceTypeAdded(ServiceEvent serviceEvent) {
        final String string = serviceEvent.getType();
        System.out.println("TYPE: " + string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Browser.this.insertSorted(Browser.this.types, string);
            }
        });
    }

    void insertSorted(DefaultListModel defaultListModel, String string) {
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (string.compareToIgnoreCase((String)defaultListModel.elementAt(i)) >= 0) continue;
            defaultListModel.insertElementAt(string, i);
            return;
        }
        defaultListModel.addElement(string);
    }

    public void serviceResolved(ServiceEvent serviceEvent) {
        String string = serviceEvent.getName();
        String string2 = serviceEvent.getType();
        ServiceInfo serviceInfo = serviceEvent.getInfo();
        if (string.equals(this.serviceList.getSelectedValue())) {
            if (serviceInfo == null) {
                this.info.setText("service not found");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                stringBuffer.append('.');
                stringBuffer.append(string2);
                stringBuffer.append('\n');
                stringBuffer.append(serviceInfo.getServer());
                stringBuffer.append(':');
                stringBuffer.append(serviceInfo.getPort());
                stringBuffer.append('\n');
                stringBuffer.append(serviceInfo.getAddress());
                stringBuffer.append(':');
                stringBuffer.append(serviceInfo.getPort());
                stringBuffer.append('\n');
                Enumeration<String> enumeration = serviceInfo.getPropertyNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = enumeration.nextElement();
                    stringBuffer.append(string3);
                    stringBuffer.append('=');
                    stringBuffer.append(serviceInfo.getPropertyString(string3));
                    stringBuffer.append('\n');
                }
                this.info.setText(stringBuffer.toString());
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (listSelectionEvent.getSource() == this.typeList) {
                this.type = (String)this.typeList.getSelectedValue();
                this.jmdns.removeServiceListener(this.type, this);
                this.services.setSize(0);
                this.info.setText("");
                if (this.type != null) {
                    this.jmdns.addServiceListener(this.type, this);
                }
            } else if (listSelectionEvent.getSource() == this.serviceList) {
                String string = (String)this.serviceList.getSelectedValue();
                if (string == null) {
                    this.info.setText("");
                } else {
                    System.out.println(this + " valueChanged() type:" + this.type + " name:" + string);
                    System.out.flush();
                    ServiceInfo serviceInfo = this.jmdns.getServiceInfo(this.type, string);
                    if (serviceInfo == null) {
                        this.info.setText("service not found");
                    } else {
                        this.jmdns.requestServiceInfo(this.type, string);
                    }
                }
            }
        }
    }

    public String toString() {
        return "RVBROWSER";
    }

    public static void main(String[] stringArray) throws IOException {
        new Browser(JmDNS.create());
    }

    class ServiceTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5607994569609827570L;

        ServiceTableModel() {
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "service";
                }
                case 1: {
                    return "address";
                }
                case 2: {
                    return "port";
                }
                case 3: {
                    return "text";
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return Browser.this.services.size();
        }

        public Object getValueAt(int n, int n2) {
            return Browser.this.services.elementAt(n);
        }
    }
}

