/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import com.strangeberry.jmdns.tools.Browser;
import com.strangeberry.jmdns.tools.Responder;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

public class Main {
    public static void main(String[] stringArray) throws IOException {
        int n = stringArray.length;
        boolean bl = false;
        InetAddress inetAddress = null;
        if (n > 0 && "-d".equals(stringArray[0])) {
            System.arraycopy(stringArray, 1, stringArray, 0, --n);
            System.getProperties().put("jmdns.debug", "1");
            bl = true;
        }
        if (n > 1 && "-i".equals(stringArray[0])) {
            inetAddress = InetAddress.getByName(stringArray[1]);
            System.arraycopy(stringArray, 2, stringArray, 0, n -= 2);
        }
        if (inetAddress == null) {
            inetAddress = InetAddress.getLocalHost();
        }
        JmDNS jmDNS = JmDNS.create(inetAddress);
        if (n == 0 || n >= 1 && "-browse".equals(stringArray[0])) {
            new Browser(jmDNS);
            for (int i = 2; i < n; ++i) {
                jmDNS.registerServiceType(stringArray[i]);
            }
        } else if (n == 1 && "-bt".equals(stringArray[0])) {
            jmDNS.addServiceTypeListener(new SampleListener());
        } else if (n == 3 && "-bs".equals(stringArray[0])) {
            jmDNS.addServiceListener(stringArray[1] + "." + stringArray[2], new SampleListener());
        } else if (n > 4 && "-rs".equals(stringArray[0])) {
            String string = stringArray[2] + "." + stringArray[3];
            String string2 = stringArray[1];
            Hashtable<String, String> hashtable = null;
            for (int i = 5; i < n; ++i) {
                int n2 = stringArray[i].indexOf(61);
                if (n2 < 0) {
                    throw new RuntimeException("not key=val: " + stringArray[i]);
                }
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                }
                hashtable.put(stringArray[i].substring(0, n2), stringArray[i].substring(n2 + 1));
            }
            jmDNS.registerService(ServiceInfo.create(string, string2, Integer.parseInt(stringArray[4]), 0, 0, hashtable));
            try {
                while (true) {
                    Thread.sleep(Integer.MAX_VALUE);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (n == 2 && "-f".equals(stringArray[0])) {
            new Responder(jmDNS, stringArray[1]);
        } else if (!bl) {
            System.out.println();
            System.out.println("jmdns:");
            System.out.println("     -d                                       - output debugging info");
            System.out.println("     -i <addr>                                - specify the interface address");
            System.out.println("     -browse [<type>...]                      - GUI browser (default)");
            System.out.println("     -bt                                      - browse service types");
            System.out.println("     -bs <type> <domain>                      - browse services by type");
            System.out.println("     -rs <name> <type> <domain> <port> <txt>  - register service");
            System.out.println("     -f <file>                                - rendezvous responder");
            System.out.println();
            System.exit(1);
        }
    }

    static class SampleListener
    implements ServiceListener,
    ServiceTypeListener {
        SampleListener() {
        }

        public void serviceAdded(ServiceEvent serviceEvent) {
            System.out.println("ADD: " + serviceEvent.getDNS().getServiceInfo(serviceEvent.getType(), serviceEvent.getName()));
        }

        public void serviceRemoved(ServiceEvent serviceEvent) {
            System.out.println("REMOVE: " + serviceEvent.getName());
        }

        public void serviceResolved(ServiceEvent serviceEvent) {
            System.out.println("RESOLVED: " + serviceEvent.getInfo());
        }

        public void serviceTypeAdded(ServiceEvent serviceEvent) {
            System.out.println("TYPE: " + serviceEvent.getType());
        }
    }
}

