/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.net.InetAddress;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.JmDNSImpl;

public abstract class JmDNS {
    public static String VERSION = "3.1.6";

    public static JmDNS create() throws IOException {
        return new JmDNSImpl(null, null);
    }

    public static JmDNS create(InetAddress addr) throws IOException {
        return new JmDNSImpl(addr, null);
    }

    public static JmDNS create(String name) throws IOException {
        return new JmDNSImpl(null, name);
    }

    public static JmDNS create(InetAddress addr, String name) throws IOException {
        return new JmDNSImpl(addr, name);
    }

    public abstract String getName();

    public abstract String getHostName();

    public abstract InetAddress getInterface() throws IOException;

    public abstract ServiceInfo getServiceInfo(String var1, String var2);

    public abstract ServiceInfo getServiceInfo(String var1, String var2, int var3);

    public abstract void requestServiceInfo(String var1, String var2);

    public abstract void requestServiceInfo(String var1, String var2, int var3);

    public abstract void addServiceTypeListener(ServiceTypeListener var1) throws IOException;

    public abstract void removeServiceTypeListener(ServiceTypeListener var1);

    public abstract void addServiceListener(String var1, ServiceListener var2);

    public abstract void removeServiceListener(String var1, ServiceListener var2);

    public abstract void registerService(ServiceInfo var1) throws IOException;

    public abstract void unregisterService(ServiceInfo var1);

    public abstract void unregisterAllServices();

    public abstract void registerServiceType(String var1);

    public abstract void close();

    public abstract void printServices();

    public abstract ServiceInfo[] list(String var1);

    public abstract ServiceInfo[] list(String var1, int var2);
}

