/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.Set;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSQuestion
extends DNSEntry {
    DNSQuestion(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        super(name, type, recordClass, unique);
    }

    public static DNSQuestion newQuestion(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        switch (type) {
            case TYPE_A: {
                return new DNS4Address(name, type, recordClass, unique);
            }
            case TYPE_A6: {
                return new DNS6Address(name, type, recordClass, unique);
            }
            case TYPE_AAAA: {
                return new DNS6Address(name, type, recordClass, unique);
            }
            case TYPE_ANY: {
                return new AllRecords(name, type, recordClass, unique);
            }
            case TYPE_HINFO: {
                return new HostInformation(name, type, recordClass, unique);
            }
            case TYPE_PTR: {
                return new Pointer(name, type, recordClass, unique);
            }
            case TYPE_SRV: {
                return new Service(name, type, recordClass, unique);
            }
            case TYPE_TXT: {
                return new Text(name, type, recordClass, unique);
            }
        }
        return new DNSQuestion(name, type, recordClass, unique);
    }

    boolean answeredBy(DNSEntry rec) {
        return this.isSameRecordClass(rec) && this.isSameType(rec) && this.getName().equals(rec.getName());
    }

    public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
    }

    protected void addAnswersForServiceInfo(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers, ServiceInfoImpl info) {
        if (info != null && info.getState() == DNSState.ANNOUNCED && this.getName().equalsIgnoreCase(info.getType())) {
            DNSRecord.Address answer = jmDNSImpl.getLocalHost().getDNS4AddressRecord();
            if (answer != null) {
                answers.add(answer);
            }
            if ((answer = jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                answers.add(answer);
            }
            answers.add(new DNSRecord.Pointer(info.getType(), DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, 3600, info.getQualifiedName()));
            answers.add(new DNSRecord.Service(info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), jmDNSImpl.getLocalHost().getName()));
            answers.add(new DNSRecord.Text(info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, true, 3600, info.getText()));
        }
    }

    @Override
    boolean isExpired(long now) {
        return false;
    }

    @Override
    public void toString(StringBuilder aLog) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllRecords
    extends DNSQuestion {
        AllRecords(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public boolean isSameType(DNSEntry entry) {
            return entry != null;
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            if (jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(this.getName())) {
                DNSRecord.Address answer = jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                if (answer != null) {
                    answers.add(answer);
                }
                if ((answer = jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                    answers.add(answer);
                }
                return;
            }
            if (jmDNSImpl.getServiceTypes().containsKey(this.getName().toLowerCase())) {
                Pointer question = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)question).addAnswers(jmDNSImpl, answers);
                return;
            }
            this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getName().toLowerCase()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Text
    extends DNSQuestion {
        Text(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getName().toLowerCase()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Service
    extends DNSQuestion {
        Service(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            if (jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(this.getName())) {
                DNSRecord.Address answer = jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                if (answer != null) {
                    answers.add(answer);
                }
                if ((answer = jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                    answers.add(answer);
                }
                return;
            }
            if (jmDNSImpl.getServiceTypes().containsKey(this.getName().toLowerCase())) {
                Pointer question = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)question).addAnswers(jmDNSImpl, answers);
                return;
            }
            this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getName().toLowerCase()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pointer
    extends DNSQuestion {
        Pointer(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            for (ServiceInfo serviceInfo : jmDNSImpl.getServices().values()) {
                this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)serviceInfo);
            }
            if (this.getName().equalsIgnoreCase("_services._mdns._udp.local.")) {
                for (String serviceType : jmDNSImpl.getServiceTypes().values()) {
                    answers.add(new DNSRecord.Pointer("_services._mdns._udp.local.", DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, 3600, serviceType));
                }
            }
        }
    }

    private static class HostInformation
    extends DNSQuestion {
        HostInformation(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DNS6Address
    extends DNSQuestion {
        DNS6Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            DNSRecord.Address answer = jmDNSImpl.getLocalHost().getDNS6AddressRecord();
            if (answer != null) {
                answers.add(answer);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DNS4Address
    extends DNSQuestion {
        DNS4Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            DNSRecord.Address answer = jmDNSImpl.getLocalHost().getDNS4AddressRecord();
            if (answer != null) {
                answers.add(answer);
            }
        }
    }
}

