/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public class HostInfo {
    private static Logger logger = Logger.getLogger(HostInfo.class.getName());
    protected String _name;
    protected InetAddress _address;
    protected NetworkInterface _interfaze;
    private int hostNameCount;

    public HostInfo(InetAddress address, String name) {
        this._address = address;
        this._name = name;
        if (address != null) {
            try {
                this._interfaze = NetworkInterface.getByInetAddress(address);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "LocalHostInfo() exception ", exception);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public NetworkInterface getInterface() {
        return this._interfaze;
    }

    synchronized String incrementHostName() {
        ++this.hostNameCount;
        int plocal = this._name.indexOf(".local.");
        int punder = this._name.lastIndexOf("-");
        this._name = this._name.substring(0, punder == -1 ? plocal : punder) + "-" + this.hostNameCount + ".local.";
        return this._name;
    }

    boolean shouldIgnorePacket(DatagramPacket packet) {
        InetAddress from;
        boolean result = false;
        if (this.getAddress() != null && (from = packet.getAddress()) != null) {
            if (from.isLinkLocalAddress() && !this.getAddress().isLinkLocalAddress()) {
                result = true;
            }
            if (from.isLoopbackAddress() && !this.getAddress().isLoopbackAddress()) {
                result = true;
            }
        }
        return result;
    }

    DNSRecord.Address getDNSAddressRecord(DNSRecord.Address address) {
        return DNSRecordType.TYPE_AAAA.equals((Object)address.getRecordType()) ? this.getDNS6AddressRecord() : this.getDNS4AddressRecord();
    }

    public DNSRecord.Address getDNS4AddressRecord() {
        if (this.getAddress() instanceof Inet4Address || this.getAddress() instanceof Inet6Address && ((Inet6Address)this.getAddress()).isIPv4CompatibleAddress()) {
            return new DNSRecord.Address(this.getName(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN, false, 3600, this.getAddress());
        }
        return null;
    }

    public DNSRecord.Address getDNS6AddressRecord() {
        if (this.getAddress() instanceof Inet6Address) {
            return new DNSRecord.Address(this.getName(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN, false, 3600, this.getAddress());
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("local host info[");
        buf.append(this.getName() != null ? this.getName() : "no name");
        buf.append(", ");
        buf.append(this.getInterface() != null ? this.getInterface().getDisplayName() : "???");
        buf.append(":");
        buf.append(this.getAddress() != null ? this.getAddress().getHostAddress() : "no address");
        buf.append("]");
        return buf.toString();
    }

    public void addAddressRecords(DNSOutgoing out, boolean authoritative) throws IOException {
        DNSRecord.Address answer = this.getDNS4AddressRecord();
        if (answer != null) {
            if (authoritative) {
                out.addAuthorativeAnswer(answer);
            } else {
                out.addAnswer(answer, 0L);
            }
        }
        if ((answer = this.getDNS6AddressRecord()) != null) {
            if (authoritative) {
                out.addAuthorativeAnswer(answer);
            } else {
                out.addAnswer(answer, 0L);
            }
        }
    }
}

