/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInfoImpl
extends ServiceInfo
implements DNSListener {
    private AtomicReference<JmDNSImpl> _dns = new AtomicReference<Object>(null);
    private volatile DNSState _state = DNSState.PROBING_1;
    private TimerTask _task;
    private String _type;
    private String _name;
    private String _server;
    private int _port;
    private int _weight;
    private int _priority;
    private byte[] _text;
    private Map<String, Object> _props;
    private InetAddress _addr;

    public ServiceInfoImpl(String type, String name, int port, String text) {
        this(type, name, port, 0, 0, text);
    }

    public ServiceInfoImpl(String type, String name, int port, int weight, int priority, String text) {
        this(type, name, port, weight, priority, (byte[])null);
        this._server = text;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
            this.writeUTF(out, text);
            byte[] data = out.toByteArray();
            this.setText(new byte[data.length + 1]);
            this.getText()[0] = (byte)data.length;
            System.arraycopy(data, 0, this.getText(), 1, data.length);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    public ServiceInfoImpl(String type, String name, int port, int weight, int priority, Map<String, ?> props) {
        this(type, name, port, weight, priority, new byte[0]);
        if (props != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                for (String key : props.keySet()) {
                    Object val = props.get(key);
                    ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                    this.writeUTF(out2, key);
                    if (val instanceof String) {
                        out2.write(61);
                        this.writeUTF(out2, (String)val);
                    } else if (val instanceof byte[]) {
                        out2.write(61);
                        byte[] bval = (byte[])val;
                        out2.write(bval, 0, bval.length);
                    } else if (val != NO_VALUE) {
                        throw new IllegalArgumentException("invalid property value: " + val);
                    }
                    byte[] data = out2.toByteArray();
                    out.write(data.length);
                    out.write(data, 0, data.length);
                }
                this.setText(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception: " + e);
            }
        }
    }

    public ServiceInfoImpl(String type, String name, int port, int weight, int priority, byte[] text) {
        this._type = type;
        this._name = name;
        this._port = port;
        this._weight = weight;
        this._priority = priority;
        this.setText(text);
    }

    ServiceInfoImpl(String type, String name) {
        if (!type.endsWith(".")) {
            throw new IllegalArgumentException("type must be fully qualified DNS name ending in '.': " + type);
        }
        this._type = type;
        this._name = name;
    }

    ServiceInfoImpl(ServiceInfo info) {
        if (info != null) {
            this._type = info.getType();
            this._name = info.getName();
            this._port = info.getPort();
            this._weight = info.getWeight();
            this._priority = info.getPriority();
            this.setText(info.getTextBytes());
        }
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getName() {
        return this._name;
    }

    void setName(String name) {
        this._name = name;
    }

    @Override
    public String getQualifiedName() {
        return (this._name != null ? this._name.toLowerCase() : "") + "." + (this._type != null ? this._type.toLowerCase() : "");
    }

    @Override
    public String getServer() {
        return this._server != null ? this._server : "";
    }

    void setServer(String server) {
        this._server = server;
    }

    @Override
    public String getHostAddress() {
        return this._addr != null ? this._addr.getHostAddress() : "";
    }

    @Override
    public InetAddress getAddress() {
        return this._addr;
    }

    void setAddress(InetAddress addr) {
        this._addr = addr;
    }

    @Override
    public InetAddress getInetAddress() {
        return this._addr;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public int getWeight() {
        return this._weight;
    }

    @Override
    public byte[] getTextBytes() {
        return this.getText();
    }

    @Override
    public String getTextString() {
        if (this.getText() == null || this.getText().length == 0 || this.getText().length == 1 && this.getText()[0] == 0) {
            return null;
        }
        return this.readUTF(this.getText(), 0, this.getText().length);
    }

    @Override
    public String getURL() {
        return this.getURL("http");
    }

    @Override
    public String getURL(String protocol) {
        String url = protocol + "://" + this.getHostAddress() + ":" + this.getPort();
        String path = this.getPropertyString("path");
        if (path != null) {
            url = path.indexOf("://") >= 0 ? path : url + (path.startsWith("/") ? path : "/" + path);
        }
        return url;
    }

    @Override
    public synchronized byte[] getPropertyBytes(String name) {
        return (byte[])this.getProperties().get(name);
    }

    @Override
    public synchronized String getPropertyString(String name) {
        byte[] data = (byte[])this.getProperties().get(name);
        if (data == null) {
            return null;
        }
        if (data == NO_VALUE) {
            return "true";
        }
        return this.readUTF(data, 0, data.length);
    }

    @Override
    public Enumeration<String> getPropertyNames() {
        Map<String, Object> properties = this.getProperties();
        Set<Object> names = properties != null ? properties.keySet() : Collections.emptySet();
        return new Vector(names).elements();
    }

    void writeUTF(OutputStream out, String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
        }
    }

    String readUTF(byte[] data, int off, int len) {
        int offset = off;
        StringBuffer buf = new StringBuffer();
        int end = offset + len;
        while (offset < end) {
            int ch = data[offset++] & 0xFF;
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (offset >= len) {
                        return null;
                    }
                    ch = (ch & 0x1F) << 6 | data[offset++] & 0x3F;
                    break;
                }
                case 14: {
                    if (offset + 2 >= len) {
                        return null;
                    }
                    ch = (ch & 0xF) << 12 | (data[offset++] & 0x3F) << 6 | data[offset++] & 0x3F;
                    break;
                }
                default: {
                    if (offset + 1 >= len) {
                        return null;
                    }
                    ch = (ch & 0x3F) << 4 | data[offset++] & 0xF;
                }
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    synchronized Map<String, Object> getProperties() {
        if (this._props == null && this.getText() != null) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            int off = 0;
            while (off < this.getText().length) {
                int i;
                int len = this.getText()[off++] & 0xFF;
                if (len == 0 || off + len > this.getText().length) {
                    properties.clear();
                    break;
                }
                for (i = 0; i < len && this.getText()[off + i] != 61; ++i) {
                }
                String name = this.readUTF(this.getText(), off, i);
                if (name == null) {
                    properties.clear();
                    break;
                }
                if (i == len) {
                    properties.put(name, NO_VALUE);
                    continue;
                }
                byte[] value = new byte[len - ++i];
                System.arraycopy(this.getText(), off + i, value, 0, len - i);
                properties.put(name, value);
                off += len;
            }
            this._props = properties;
        }
        return this._props != null ? this._props : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(DNSCache dnsCache, long now, DNSEntry rec) {
        if (rec != null && !rec.isExpired(now)) {
            JmDNSImpl dns;
            switch (rec.getRecordType()) {
                case TYPE_A: 
                case TYPE_AAAA: {
                    if (!rec.getName().equalsIgnoreCase(this.getServer())) break;
                    this._addr = ((DNSRecord.Address)rec).getAddress();
                    break;
                }
                case TYPE_SRV: {
                    if (!rec.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    DNSRecord.Service srv = (DNSRecord.Service)rec;
                    this._server = srv._server;
                    this._port = srv._port;
                    this._weight = srv._weight;
                    this._priority = srv._priority;
                    this._addr = null;
                    this.updateRecord(dnsCache, now, dnsCache.getDNSEntry(this._server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN));
                    break;
                }
                case TYPE_TXT: {
                    if (!rec.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    DNSRecord.Text txt = (DNSRecord.Text)rec;
                    this.setText(txt._text);
                    break;
                }
            }
            if (this.hasData() && (dns = (JmDNSImpl)this._dns.getAndSet(null)) != null) {
                dns.handleServiceResolved(this);
            }
            ServiceInfoImpl serviceInfoImpl = this;
            synchronized (serviceInfoImpl) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized boolean hasData() {
        return this.getServer() != null && this.getAddress() != null && this.getTextBytes() != null && this.getTextBytes().length > 0;
    }

    public synchronized void advanceState() {
        this._state = this._state.advance();
        this.notifyAll();
    }

    synchronized void revertState() {
        this._state = this._state.revert();
        this.notifyAll();
    }

    synchronized void cancel() {
        this._state = DNSState.CANCELED;
        this.notifyAll();
    }

    public DNSState getState() {
        return this._state;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfoImpl && this.getQualifiedName().equals(((ServiceInfoImpl)obj).getQualifiedName());
    }

    @Override
    public String getNiceTextString() {
        StringBuffer buf = new StringBuffer();
        int len = this.getText().length;
        for (int i = 0; i < len; ++i) {
            if (i >= 200) {
                buf.append("...");
                break;
            }
            int ch = this.getText()[i] & 0xFF;
            if (ch < 32 || ch > 127) {
                buf.append("\\0");
                buf.append(Integer.toString(ch, 8));
                continue;
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[" + this.getClass().getName() + "@" + System.identityHashCode(this) + " ");
        buf.append("name: '");
        buf.append(this.getQualifiedName());
        buf.append("' address: '");
        buf.append(this.getAddress());
        buf.append(':');
        buf.append(this.getPort());
        buf.append("'");
        buf.append("' has ");
        buf.append(this.hasData() ? "" : "NO ");
        buf.append("data");
        if (this.getText().length > 0) {
            buf.append("\n");
            buf.append(this.getNiceTextString());
        }
        buf.append(']');
        return buf.toString();
    }

    public void addAnswers(DNSOutgoing out, int ttl, HostInfo localHost) throws IOException {
        out.addAnswer(new DNSRecord.Pointer(this._type, DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, ttl, this.getQualifiedName()), 0L);
        out.addAnswer(new DNSRecord.Service(this.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, true, ttl, this._priority, this._weight, this._port, localHost.getName()), 0L);
        out.addAnswer(new DNSRecord.Text(this.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, true, ttl, this.getText()), 0L);
    }

    public void setTask(TimerTask task) {
        this._task = task;
    }

    public TimerTask getTask() {
        return this._task;
    }

    public void setText(byte[] text) {
        this._text = text;
    }

    public byte[] getText() {
        return this._text != null ? this._text : new byte[]{};
    }

    public void setDns(JmDNSImpl dns) {
        this._dns.set(dns);
    }

    public JmDNSImpl getDns() {
        return this._dns.get();
    }
}

