/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DNSState {
    PROBING_1("probing 1", StateClass.probing),
    PROBING_2("probing 2", StateClass.probing),
    PROBING_3("probing 3", StateClass.probing),
    ANNOUNCING_1("announcing 1", StateClass.announcing),
    ANNOUNCING_2("announcing 2", StateClass.announcing),
    ANNOUNCED("announced", StateClass.announced),
    CANCELED("canceled", StateClass.canceled);

    private final String _name;
    private final StateClass _state;

    private DNSState(String name, StateClass state) {
        this._name = name;
        this._state = state;
    }

    public final String toString() {
        return this._name;
    }

    public final DNSState advance() {
        switch (this) {
            case PROBING_1: {
                return PROBING_2;
            }
            case PROBING_2: {
                return PROBING_3;
            }
            case PROBING_3: {
                return ANNOUNCING_1;
            }
            case ANNOUNCING_1: {
                return ANNOUNCING_2;
            }
            case ANNOUNCING_2: {
                return ANNOUNCED;
            }
            case ANNOUNCED: {
                return ANNOUNCED;
            }
            case CANCELED: {
                return CANCELED;
            }
        }
        return this;
    }

    public final DNSState revert() {
        return this._state == StateClass.canceled ? CANCELED : PROBING_1;
    }

    public final boolean isProbing() {
        return this._state == StateClass.probing;
    }

    public final boolean isAnnouncing() {
        return this._state == StateClass.announcing;
    }

    public final boolean isAnnounced() {
        return this._state == StateClass.announced;
    }

    public final boolean isCanceled() {
        return this._state == StateClass.canceled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StateClass {
        probing,
        announcing,
        announced,
        canceled;

    }
}

