/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class TypeResolver
extends DNSTask {
    static Logger logger = Logger.getLogger(TypeResolver.class.getName());
    int _count = 0;

    public TypeResolver(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
    }

    public void start(Timer timer) {
        if (this._jmDNSImpl.getState() != DNSState.CANCELED) {
            timer.schedule((TimerTask)this, 225L, 225L);
        }
    }

    public void run() {
        try {
            if (this._jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this._count++ < 3) {
                    logger.finer("run() JmDNS querying type");
                    DNSOutgoing out = new DNSOutgoing(0);
                    out.addQuestion(DNSQuestion.newQuestion("_services._mdns._udp.local.", DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false));
                    for (String type : this._jmDNSImpl.getServiceTypes().values()) {
                        out.addAnswer(new DNSRecord.Pointer("_services._mdns._udp.local.", DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, 3600, type), 0L);
                    }
                    this._jmDNSImpl.send(out);
                } else {
                    this.cancel();
                }
            } else if (this._jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "run() exception ", e);
            this._jmDNSImpl.recover();
        }
    }
}

