/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.Enumeration;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class Browser
extends JFrame
implements ServiceListener,
ServiceTypeListener,
ListSelectionListener {
    private static final long serialVersionUID = 5750114542524415107L;
    JmDNS jmdns;
    String type;
    DefaultListModel types;
    JList typeList;
    DefaultListModel services;
    JList serviceList;
    JTextArea info;

    Browser(JmDNS mDNS) throws IOException {
        super("JmDNS Browser");
        this.jmdns = mDNS;
        Color bg = new Color(230, 230, 230);
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        Container content = this.getContentPane();
        content.setLayout(new GridLayout(1, 3));
        this.types = new DefaultListModel();
        this.typeList = new JList(this.types);
        this.typeList.setBorder(border);
        this.typeList.setBackground(bg);
        this.typeList.setSelectionMode(0);
        this.typeList.addListSelectionListener(this);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BorderLayout());
        typePanel.add("North", new JLabel("Types"));
        typePanel.add("Center", new JScrollPane(this.typeList, 20, 30));
        content.add(typePanel);
        this.services = new DefaultListModel();
        this.serviceList = new JList(this.services);
        this.serviceList.setBorder(border);
        this.serviceList.setBackground(bg);
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(this);
        JPanel servicePanel = new JPanel();
        servicePanel.setLayout(new BorderLayout());
        servicePanel.add("North", new JLabel("Services"));
        servicePanel.add("Center", new JScrollPane(this.serviceList, 20, 30));
        content.add(servicePanel);
        this.info = new JTextArea();
        this.info.setBorder(border);
        this.info.setBackground(bg);
        this.info.setEditable(false);
        this.info.setLineWrap(true);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.add("North", new JLabel("Details"));
        infoPanel.add("Center", new JScrollPane(this.info, 20, 30));
        content.add(infoPanel);
        this.setDefaultCloseOperation(3);
        this.setLocation(100, 100);
        this.setSize(600, 400);
        mDNS.addServiceTypeListener(this);
        String[] list = new String[]{"_http._tcp.local.", "_ftp._tcp.local.", "_tftp._tcp.local.", "_ssh._tcp.local.", "_smb._tcp.local.", "_printer._tcp.local.", "_airport._tcp.local.", "_afpovertcp._tcp.local.", "_ichat._tcp.local.", "_eppc._tcp.local.", "_presence._tcp.local.", "_rfb._tcp.local.", "_daap._tcp.local.", "_touchcs._tcp.local."};
        int i = 0;
        while (i < list.length) {
            mDNS.registerServiceType(list[i]);
            ++i;
        }
        this.setVisible(true);
    }

    @Override
    public void serviceAdded(ServiceEvent event) {
        final String name = event.getName();
        System.out.println("ADD: " + name);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Browser.this.insertSorted(Browser.this.services, name);
            }
        });
    }

    @Override
    public void serviceRemoved(ServiceEvent event) {
        final String name = event.getName();
        System.out.println("REMOVE: " + name);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Browser.this.services.removeElement(name);
            }
        });
    }

    @Override
    public void serviceTypeAdded(ServiceEvent event) {
        final String aType = event.getType();
        System.out.println("TYPE: " + aType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Browser.this.insertSorted(Browser.this.types, aType);
            }
        });
    }

    void insertSorted(DefaultListModel model, String value) {
        int i = 0;
        int n = model.getSize();
        while (i < n) {
            if (value.compareToIgnoreCase((String)model.elementAt(i)) < 0) {
                model.insertElementAt(value, i);
                return;
            }
            ++i;
        }
        model.addElement(value);
    }

    @Override
    public void serviceResolved(ServiceEvent event) {
        String aName = event.getName();
        String aType = event.getType();
        ServiceInfo anInfo = event.getInfo();
        if (aName.equals(this.serviceList.getSelectedValue())) {
            if (anInfo == null) {
                this.info.setText("service not found");
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append(aName);
                buf.append('.');
                buf.append(aType);
                buf.append('\n');
                buf.append(anInfo.getServer());
                buf.append(':');
                buf.append(anInfo.getPort());
                buf.append('\n');
                buf.append(anInfo.getAddress());
                buf.append(':');
                buf.append(anInfo.getPort());
                buf.append('\n');
                Enumeration<String> names = anInfo.getPropertyNames();
                while (names.hasMoreElements()) {
                    String prop = names.nextElement();
                    buf.append(prop);
                    buf.append('=');
                    buf.append(anInfo.getPropertyString(prop));
                    buf.append('\n');
                }
                this.info.setText(buf.toString());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (e.getSource() == this.typeList) {
                this.type = (String)this.typeList.getSelectedValue();
                this.jmdns.removeServiceListener(this.type, this);
                this.services.setSize(0);
                this.info.setText("");
                if (this.type != null) {
                    this.jmdns.addServiceListener(this.type, this);
                }
            } else if (e.getSource() == this.serviceList) {
                String name = (String)this.serviceList.getSelectedValue();
                if (name == null) {
                    this.info.setText("");
                } else {
                    System.out.println(this + " valueChanged() type:" + this.type + " name:" + name);
                    System.out.flush();
                    ServiceInfo service = this.jmdns.getServiceInfo(this.type, name);
                    if (service == null) {
                        this.info.setText("service not found");
                    } else {
                        this.jmdns.requestServiceInfo(this.type, name);
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return "RVBROWSER";
    }

    public static void main(String[] argv) throws IOException {
        new Browser(JmDNS.create());
    }

    class ServiceTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5607994569609827570L;

        ServiceTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "service";
                }
                case 1: {
                    return "address";
                }
                case 2: {
                    return "port";
                }
                case 3: {
                    return "text";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return Browser.this.services.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return Browser.this.services.elementAt(row);
        }
    }
}

