/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public class DNSCache
extends AbstractMap<String, List<? extends DNSEntry>> {
    private transient Set<Map.Entry<String, List<? extends DNSEntry>>> _entrySet = null;
    public static final DNSCache EmptyCache = new _EmptyCache();

    public DNSCache() {
    }

    public DNSCache(DNSCache map) {
        this();
        this.putAll(map);
    }

    public DNSCache(int initialCapacity) {
        this();
        this._entrySet = new HashSet<Map.Entry<String, List<? extends DNSEntry>>>(initialCapacity);
    }

    @Override
    public Set<Map.Entry<String, List<? extends DNSEntry>>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new HashSet<Map.Entry<String, List<? extends DNSEntry>>>();
        }
        return this._entrySet;
    }

    protected Map.Entry<String, List<? extends DNSEntry>> getEntry(String key) {
        String stringKey = key != null ? key.trim().toLowerCase() : null;
        for (Map.Entry<String, List<? extends DNSEntry>> entry : this.entrySet()) {
            if (!(stringKey != null ? stringKey.equals(entry.getKey()) : entry.getKey() == null)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends DNSEntry> put(String key, List<? extends DNSEntry> value) {
        DNSCache dNSCache = this;
        synchronized (dNSCache) {
            List<? extends DNSEntry> oldValue = null;
            Map.Entry<String, List<? extends DNSEntry>> oldEntry = this.getEntry(key);
            if (oldEntry != null) {
                oldValue = oldEntry.setValue(value);
            } else {
                this.entrySet().add(new _CacheEntry(key, value));
            }
            return oldValue;
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new DNSCache(this);
    }

    public synchronized Collection<DNSEntry> allValues() {
        ArrayList<DNSEntry> allValues = new ArrayList<DNSEntry>();
        for (List entry : this.values()) {
            if (entry == null) continue;
            allValues.addAll(entry);
        }
        return allValues;
    }

    public synchronized Collection<? extends DNSEntry> getDNSEntryList(String name) {
        return (Collection)this.get(name != null ? name.toLowerCase() : null);
    }

    public synchronized DNSEntry getDNSEntry(DNSEntry dnsEntry) {
        Collection<? extends DNSEntry> entryList;
        DNSEntry result = null;
        if (dnsEntry != null && (entryList = this.getDNSEntryList(dnsEntry.getKey())) != null) {
            for (DNSEntry dNSEntry : entryList) {
                if (!dnsEntry.equals(dNSEntry)) continue;
                result = dNSEntry;
                break;
            }
        }
        return result;
    }

    public synchronized DNSEntry getDNSEntry(String name, DNSRecordType type, DNSRecordClass recordClass) {
        DNSEntry result = null;
        Collection<? extends DNSEntry> entryList = this.getDNSEntryList(name);
        if (entryList != null) {
            for (DNSEntry dNSEntry : entryList) {
                if (!dNSEntry.getRecordType().equals((Object)type) || DNSRecordClass.CLASS_ANY != recordClass && !dNSEntry.getRecordClass().equals((Object)recordClass)) continue;
                result = dNSEntry;
                break;
            }
        }
        return result;
    }

    public synchronized boolean addDNSEntry(DNSEntry dnsEntry) {
        boolean result = false;
        if (dnsEntry != null) {
            Map.Entry<String, List<? extends DNSEntry>> oldEntry = this.getEntry(dnsEntry.getKey());
            ArrayList<DNSEntry> aNewValue = null;
            aNewValue = oldEntry != null ? new ArrayList(oldEntry.getValue()) : new ArrayList<DNSEntry>();
            aNewValue.add(dnsEntry);
            if (oldEntry != null) {
                oldEntry.setValue(aNewValue);
            } else {
                this.entrySet().add(new _CacheEntry(dnsEntry.getKey(), aNewValue));
            }
            result = true;
        }
        return result;
    }

    public synchronized boolean removeDNSEntry(DNSEntry dnsEntry) {
        Collection<? extends DNSEntry> entry;
        boolean result = false;
        if (dnsEntry != null && (entry = this.getDNSEntryList(dnsEntry.getKey())) != null) {
            result = entry.remove(dnsEntry);
            if (entry.size() == 0) {
                this.remove(dnsEntry.getKey());
            }
        }
        return result;
    }

    @Override
    public synchronized String toString() {
        StringBuffer aLog = new StringBuffer();
        aLog.append("\t---- cache ----");
        for (Map.Entry<String, List<? extends DNSEntry>> entry : this.entrySet()) {
            aLog.append("\n\t\t" + entry.toString());
        }
        return aLog.toString();
    }

    protected static class _CacheEntry
    implements Map.Entry<String, List<? extends DNSEntry>> {
        private List<? extends DNSEntry> _value;
        private String _key;

        protected _CacheEntry(String key, List<? extends DNSEntry> value) {
            this._key = key != null ? key.trim().toLowerCase() : null;
            this._value = value;
        }

        protected _CacheEntry(Map.Entry<String, List<? extends DNSEntry>> entry) {
            if (entry instanceof _CacheEntry) {
                this._key = ((_CacheEntry)entry).getKey();
                this._value = ((_CacheEntry)entry).getValue();
            }
        }

        @Override
        public String getKey() {
            return this._key != null ? this._key : "";
        }

        @Override
        public List<? extends DNSEntry> getValue() {
            return this._value;
        }

        @Override
        public List<? extends DNSEntry> setValue(List<? extends DNSEntry> value) {
            List<? extends DNSEntry> oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object entry) {
            if (!(entry instanceof Map.Entry)) {
                return false;
            }
            return this.getKey().equals(((Map.Entry)entry).getKey()) && this.getValue().equals(((Map.Entry)entry).getValue());
        }

        @Override
        public int hashCode() {
            return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
        }

        public synchronized String toString() {
            StringBuffer aLog = new StringBuffer();
            aLog.append("\n\t\tname '" + this._key + "'");
            if (this._value != null) {
                for (DNSEntry dNSEntry : this._value) {
                    aLog.append("\n\t\t\t" + dNSEntry.toString());
                }
            } else {
                aLog.append(" no entries");
            }
            return aLog.toString();
        }
    }

    static class _EmptyCache
    extends DNSCache {
        _EmptyCache() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public List<DNSEntry> get(Object key) {
            return null;
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<List<? extends DNSEntry>> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<String, List<? extends DNSEntry>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        @Override
        public List<? extends DNSEntry> put(String key, List<? extends DNSEntry> value) {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

