/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public abstract class DNSEntry {
    String _key;
    String _name;
    DNSRecordType _type;
    DNSRecordClass _dnsClass;
    boolean _unique;

    DNSEntry(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        this._name = name;
        this._key = name != null ? name.trim().toLowerCase() : null;
        this._type = type;
        this._dnsClass = recordClass;
        this._unique = unique;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof DNSEntry) {
            DNSEntry other = (DNSEntry)obj;
            result = this.getKey().equals(other.getKey()) && this.getRecordType().equals((Object)other.getRecordType()) && this._dnsClass == other.getRecordClass();
        }
        return result;
    }

    public String getName() {
        return this._name != null ? this._name : "";
    }

    public String getKey() {
        return this._key != null ? this._key : "";
    }

    public void setName(String value) {
        this._key = value != null ? value.trim().toLowerCase() : null;
        this._name = value;
    }

    public DNSRecordType getRecordType() {
        return this._type != null ? this._type : DNSRecordType.TYPE_IGNORE;
    }

    public DNSRecordClass getRecordClass() {
        return this._dnsClass != null ? this._dnsClass : DNSRecordClass.CLASS_UNKNOWN;
    }

    public boolean isUnique() {
        return this._unique;
    }

    abstract boolean isExpired(long var1);

    public boolean isSameRecordClass(DNSEntry entry) {
        return entry != null && entry.getRecordClass() == this.getRecordClass();
    }

    public boolean isSameType(DNSEntry entry) {
        return entry != null && entry.getRecordType() == this.getRecordType();
    }

    protected void toByteArray(DataOutputStream dout) throws IOException {
        dout.write(this.getName().getBytes("UTF8"));
        dout.writeShort(this.getRecordType().indexValue());
        dout.writeShort(this.getRecordClass().indexValue());
    }

    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            this.toByteArray(dout);
            dout.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError();
        }
    }

    public int compareTo(DNSEntry that) {
        byte[] thisBytes = this.toByteArray();
        byte[] thatBytes = that.toByteArray();
        int i = 0;
        int n = Math.min(thisBytes.length, thatBytes.length);
        while (i < n) {
            if (thisBytes[i] > thatBytes[i]) {
                return 1;
            }
            if (thisBytes[i] < thatBytes[i]) {
                return -1;
            }
            ++i;
        }
        return thisBytes.length - thatBytes.length;
    }

    public int hashCode() {
        return this._name.hashCode() + this.getRecordType().indexValue() + this.getRecordClass().indexValue();
    }

    public String toString() {
        StringBuilder aLog = new StringBuilder();
        aLog.append("[ " + this.getClass().getName());
        aLog.append(" type: " + (Object)((Object)this.getRecordType()));
        aLog.append(", class: " + (Object)((Object)this.getRecordClass()));
        aLog.append(this._unique ? "-unique," : ",");
        aLog.append(" name: " + this._name);
        this.toString(aLog);
        aLog.append(" ]");
        return aLog.toString();
    }

    public void toString(StringBuilder aLog) {
        aLog.append(super.toString());
    }

    public String toString(String hdr, String other) {
        return String.valueOf(hdr) + "[" + (Object)((Object)this.getRecordType()) + "," + (Object)((Object)this.getRecordClass()) + (this._unique ? "-unique," : ",") + this._name + (other != null ? "," + other + "]" : "]");
    }
}

