/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSMessage;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;

public final class DNSOutgoing
extends DNSMessage {
    public static boolean USE_DOMAIN_NAME_COMPRESSION = true;
    private static Logger logger = Logger.getLogger(DNSOutgoing.class.getName());
    private Map<String, Integer> _names = new Hashtable<String, Integer>();
    byte[] _data;
    int _off;
    int _len;

    public DNSOutgoing(int flags) {
        this(flags, true, 1460);
    }

    public DNSOutgoing(int flags, boolean multicast) {
        this(flags, multicast, 1460);
    }

    public DNSOutgoing(int flags, boolean multicast, int senderUDPPayload) {
        super(flags, 0, multicast);
        this._data = new byte[senderUDPPayload];
        this._off = 12;
    }

    public void addQuestion(DNSQuestion rec) throws IOException {
        if (this.getNumberOfAnswers() > 0 || this.getNumberOfAuthorities() > 0 || this.getNumberOfAdditionals() > 0) {
            throw new IllegalStateException("Questions must be added before answers");
        }
        this._questions.add(rec);
        this.writeQuestion(rec);
    }

    public void addAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        if (this.getNumberOfAuthorities() > 0 || this.getNumberOfAdditionals() > 0) {
            throw new IllegalStateException("Answers must be added before authorities and additionals");
        }
        if (!rec.suppressedBy(in)) {
            this.addAnswer(rec, 0L);
        }
    }

    void addAdditionalAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        if (this._off < this._data.length - 200 && !rec.suppressedBy(in)) {
            this._additionals.add(rec);
            this.writeRecord(rec, 0L);
        }
    }

    public void addAnswer(DNSRecord rec, long now) throws IOException {
        if (this.getNumberOfAuthorities() > 0 || this.getNumberOfAdditionals() > 0) {
            throw new IllegalStateException("Questions must be added before answers");
        }
        if (!(rec == null || now != 0L && rec.isExpired(now))) {
            this._answers.add(rec);
            this.writeRecord(rec, now);
        }
    }

    public void addAuthorativeAnswer(DNSRecord rec) throws IOException {
        if (this.getNumberOfAdditionals() > 0) {
            throw new IllegalStateException("Authorative answers must be added before additional answers");
        }
        this._authoritativeAnswers.add(rec);
        this.writeRecord(rec, 0L);
    }

    void writeByte(int value) throws IOException {
        if (this._off >= this._data.length) {
            throw new IOException("buffer full");
        }
        this._data[this._off++] = (byte)value;
    }

    void writeBytes(String str, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeByte(str.charAt(off + i));
            ++i;
        }
    }

    void writeBytes(byte[] data) throws IOException {
        if (data != null) {
            this.writeBytes(data, 0, data.length);
        }
    }

    void writeBytes(byte[] data, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeByte(data[off + i]);
            ++i;
        }
    }

    void writeShort(int value) throws IOException {
        this.writeByte(value >> 8);
        this.writeByte(value);
    }

    void writeInt(int value) throws IOException {
        this.writeShort(value >> 16);
        this.writeShort(value);
    }

    void writeUTF(String str, int off, int len) throws IOException {
        char ch;
        int utflen = 0;
        int i = 0;
        while (i < len) {
            ch = str.charAt(off + i);
            utflen = ch >= '\u0001' && ch <= '\u007f' ? ++utflen : (ch > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        this.writeByte(utflen);
        i = 0;
        while (i < len) {
            ch = str.charAt(off + i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                this.writeByte(ch);
            } else if (ch > '\u07ff') {
                this.writeByte(0xE0 | ch >> 12 & 0xF);
                this.writeByte(0x80 | ch >> 6 & 0x3F);
                this.writeByte(0x80 | ch >> 0 & 0x3F);
            } else {
                this.writeByte(0xC0 | ch >> 6 & 0x1F);
                this.writeByte(0x80 | ch >> 0 & 0x3F);
            }
            ++i;
        }
    }

    void writeName(String name) throws IOException {
        this.writeName(name, true);
    }

    void writeName(String name, boolean useCompression) throws IOException {
        String aName = name;
        while (true) {
            int n;
            if ((n = aName.indexOf(46)) < 0) {
                n = aName.length();
            }
            if (n <= 0) {
                this.writeByte(0);
                return;
            }
            if (useCompression && USE_DOMAIN_NAME_COMPRESSION) {
                Integer offset = this._names.get(aName);
                if (offset != null) {
                    int val = offset;
                    if (val > this._off) {
                        logger.log(Level.WARNING, "DNSOutgoing writeName failed val=" + val + " name=" + aName);
                    }
                    this.writeByte(val >> 8 | 0xC0);
                    this.writeByte(val & 0xFF);
                    return;
                }
                this._names.put(aName, this._off);
            }
            this.writeUTF(aName, 0, n);
            if (!(aName = aName.substring(n)).startsWith(".")) continue;
            aName = aName.substring(1);
        }
    }

    void writeQuestion(DNSQuestion question) throws IOException {
        this.writeName(question.getName());
        this.writeShort(question.getRecordType().indexValue());
        this.writeShort(question.getRecordClass().indexValue());
    }

    void writeRecord(DNSRecord rec, long now) throws IOException {
        int save = this._off;
        try {
            this.writeName(rec.getName());
            this.writeShort(rec.getRecordType().indexValue());
            this.writeShort(rec.getRecordClass().indexValue() | (rec.isUnique() && this.isMulticast() ? 32768 : 0));
            this.writeInt(now == 0L ? rec.getTTL() : rec.getRemainingTTL(now));
            this.writeShort(0);
            int start = this._off;
            rec.write(this);
            int len = this._off - start;
            this._data[start - 2] = (byte)(len >> 8);
            this._data[start - 1] = (byte)(len & 0xFF);
        }
        catch (IOException e) {
            this._off = save;
            throw e;
        }
    }

    void finish() throws IOException {
        int save = this._off;
        this._off = 0;
        this.writeShort(this._multicast ? 0 : this._id);
        this.writeShort(this._flags);
        this.writeShort(this.getNumberOfQuestions());
        this.writeShort(this.getNumberOfAnswers());
        this.writeShort(this.getNumberOfAuthorities());
        this.writeShort(this.getNumberOfAdditionals());
        this._off = save;
    }

    @Override
    public boolean isQuery() {
        return (this._flags & 0x8000) == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.isQuery() ? "dns[query:" : "dns[response:");
        buf.append(" id=0x");
        buf.append(Integer.toHexString(this._id));
        if (this._flags != 0) {
            buf.append(", flags=0x");
            buf.append(Integer.toHexString(this._flags));
            if ((this._flags & 0x8000) != 0) {
                buf.append(":r");
            }
            if ((this._flags & 0x400) != 0) {
                buf.append(":aa");
            }
            if ((this._flags & 0x200) != 0) {
                buf.append(":tc");
            }
        }
        if (this.getNumberOfQuestions() > 0) {
            buf.append(", questions=");
            buf.append(this.getNumberOfQuestions());
        }
        if (this.getNumberOfAnswers() > 0) {
            buf.append(", answers=");
            buf.append(this.getNumberOfAnswers());
        }
        if (this.getNumberOfAuthorities() > 0) {
            buf.append(", authorities=");
            buf.append(this.getNumberOfAuthorities());
        }
        if (this.getNumberOfAdditionals() > 0) {
            buf.append(", additionals=");
            buf.append(this.getNumberOfAdditionals());
        }
        buf.append(",\nnames=" + this._names);
        buf.append(",\nauthorativeAnswers=" + this._authoritativeAnswers);
        buf.append("]");
        return buf.toString();
    }

    String print(boolean dump) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.print());
        if (dump) {
            int off = 0;
            int len = this._data.length;
            while (off < len) {
                int n = Math.min(32, len - off);
                if (off < 10) {
                    buf.append(' ');
                }
                if (off < 100) {
                    buf.append(' ');
                }
                buf.append(off);
                buf.append(':');
                int i = 0;
                while (i < n) {
                    if (i % 8 == 0) {
                        buf.append(' ');
                    }
                    buf.append(Integer.toHexString((this._data[off + i] & 0xF0) >> 4));
                    buf.append(Integer.toHexString((this._data[off + i] & 0xF) >> 0));
                    ++i;
                }
                buf.append("\n");
                buf.append("    ");
                i = 0;
                while (i < n) {
                    if (i % 8 == 0) {
                        buf.append(' ');
                    }
                    buf.append(' ');
                    int ch = this._data[off + i] & 0xFF;
                    buf.append(ch > 32 && ch < 127 ? (char)ch : (char)'.');
                    ++i;
                }
                buf.append("\n");
                if (off + 32 >= 256) {
                    buf.append("....\n");
                    break;
                }
                off += 32;
            }
        }
        return buf.toString();
    }
}

