/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSState;

class SocketListener
implements Runnable {
    static Logger logger = Logger.getLogger(SocketListener.class.getName());
    private final JmDNSImpl _jmDNSImpl;

    SocketListener(JmDNSImpl jmDNSImpl) {
        this._jmDNSImpl = jmDNSImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            try {
                byte[] buf = new byte[8972];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (this._jmDNSImpl.getState() != DNSState.CANCELED) {
                    packet.setLength(buf.length);
                    this._jmDNSImpl.getSocket().receive(packet);
                    if (this._jmDNSImpl.getState() != DNSState.CANCELED) {
                        try {
                            if (this._jmDNSImpl.getLocalHost().shouldIgnorePacket(packet)) continue;
                            DNSIncoming msg = new DNSIncoming(packet);
                            logger.finest("SocketListener.run() JmDNS in:" + msg.print(true));
                            this._jmDNSImpl.ioLock();
                            try {
                                if (msg.isQuery()) {
                                    if (packet.getPort() != 5353) {
                                        this._jmDNSImpl.handleQuery(msg, packet.getAddress(), packet.getPort());
                                    }
                                    this._jmDNSImpl.handleQuery(msg, this._jmDNSImpl.getGroup(), 5353);
                                    continue;
                                }
                                this._jmDNSImpl.handleResponse(msg);
                            }
                            finally {
                                this._jmDNSImpl.ioUnlock();
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "run() exception ", e);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this._jmDNSImpl.getState() == DNSState.CANCELED) break block14;
                logger.log(Level.WARNING, "run() exception ", e);
                this._jmDNSImpl.recover();
            }
        }
        JmDNSImpl jmDNSImpl = this._jmDNSImpl;
        synchronized (jmDNSImpl) {
            this._jmDNSImpl.notifyAll();
        }
    }
}

