/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

public enum DNSLabel {
    Unknown("", 128),
    Standard("standard label", 0),
    Compressed("compressed label", 192),
    Extended("extended label", 64);

    static final int LABEL_MASK = 192;
    static final int LABEL_NOT_MASK = 63;
    private final String _externalName;
    private final int _index;

    private DNSLabel(String name, int index) {
        this._externalName = name;
        this._index = index;
    }

    public String externalName() {
        return this._externalName;
    }

    public int indexValue() {
        return this._index;
    }

    public static DNSLabel labelForByte(int index) {
        int maskedIndex = index & 0xC0;
        DNSLabel[] dNSLabelArray = DNSLabel.values();
        int n = dNSLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            DNSLabel aLabel = dNSLabelArray[n2];
            if (aLabel._index == maskedIndex) {
                return aLabel;
            }
            ++n2;
        }
        return Unknown;
    }

    public static int labelValue(int index) {
        return index & 0x3F;
    }

    public String toString() {
        return String.valueOf(this.name()) + " index " + this.indexValue();
    }
}

