/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

public enum DNSOperationCode {
    Query("Query", 0),
    IQuery("Inverse Query", 1),
    Status("Status", 2),
    Unassigned("Unassigned", 3),
    Notify("Notify", 4),
    Update("Update", 5);

    static final int OpCode_MASK = 30720;
    private final String _externalName;
    private final int _index;

    private DNSOperationCode(String name, int index) {
        this._externalName = name;
        this._index = index;
    }

    public String externalName() {
        return this._externalName;
    }

    public int indexValue() {
        return this._index;
    }

    public static DNSOperationCode operationCodeForFlags(int flags) {
        int maskedIndex = (flags & 0x7800) >> 11;
        DNSOperationCode[] dNSOperationCodeArray = DNSOperationCode.values();
        int n = dNSOperationCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DNSOperationCode aCode = dNSOperationCodeArray[n2];
            if (aCode._index == maskedIndex) {
                return aCode;
            }
            ++n2;
        }
        return Unassigned;
    }

    public String toString() {
        return String.valueOf(this.name()) + " index " + this.indexValue();
    }
}

