/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum DNSRecordClass {
    CLASS_UNKNOWN("?", 0),
    CLASS_IN("in", 1),
    CLASS_CS("cs", 2),
    CLASS_CH("ch", 3),
    CLASS_HS("hs", 4),
    CLASS_NONE("none", 254),
    CLASS_ANY("any", 255);

    private static Logger logger;
    public static final int CLASS_MASK = Short.MAX_VALUE;
    public static final int CLASS_UNIQUE = 32768;
    public static final boolean UNIQUE = true;
    public static final boolean NOT_UNIQUE = false;
    private final String _externalName;
    private final int _index;

    static {
        logger = Logger.getLogger(DNSRecordClass.class.getName());
    }

    private DNSRecordClass(String name, int index) {
        this._externalName = name;
        this._index = index;
    }

    public String externalName() {
        return this._externalName;
    }

    public int indexValue() {
        return this._index;
    }

    public boolean isUnique() {
        return (this._index & 0x8000) != 0;
    }

    public static DNSRecordClass classForName(String name) {
        if (name != null) {
            String aName = name.toLowerCase();
            DNSRecordClass[] dNSRecordClassArray = DNSRecordClass.values();
            int n = dNSRecordClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                DNSRecordClass aClass = dNSRecordClassArray[n2];
                if (aClass._externalName.equals(aName)) {
                    return aClass;
                }
                ++n2;
            }
        }
        logger.log(Level.WARNING, "Could not find record class for name: " + name);
        return CLASS_UNKNOWN;
    }

    public static DNSRecordClass classForIndex(int index) {
        int maskedIndex = index & Short.MAX_VALUE;
        DNSRecordClass[] dNSRecordClassArray = DNSRecordClass.values();
        int n = dNSRecordClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            DNSRecordClass aClass = dNSRecordClassArray[n2];
            if (aClass._index == maskedIndex) {
                return aClass;
            }
            ++n2;
        }
        logger.log(Level.WARNING, "Could not find record class for index: " + index);
        return CLASS_UNKNOWN;
    }

    public String toString() {
        return String.valueOf(this.name()) + " index " + this.indexValue();
    }
}

