/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class RecordReaper
extends DNSTask {
    static Logger logger = Logger.getLogger(RecordReaper.class.getName());

    public RecordReaper(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
    }

    public void start(Timer timer) {
        if (this._jmDNSImpl.getState() != DNSState.CANCELED) {
            timer.schedule((TimerTask)this, 10000L, 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JmDNSImpl jmDNSImpl = this._jmDNSImpl;
        synchronized (jmDNSImpl) {
            if (this._jmDNSImpl.getState() == DNSState.CANCELED) {
                return;
            }
            logger.finest("run() JmDNS reaping cache");
            Collection<DNSEntry> dnsEntryLits = this._jmDNSImpl.getCache().allValues();
            long now = System.currentTimeMillis();
            for (DNSEntry entry : dnsEntryLits) {
                DNSRecord record = (DNSRecord)entry;
                if (!record.isExpired(now)) continue;
                this._jmDNSImpl.updateRecord(now, record);
                this._jmDNSImpl.getCache().removeDNSEntry(record);
            }
        }
    }
}

