/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class Renewer
extends DNSTask {
    static Logger logger = Logger.getLogger(Renewer.class.getName());
    DNSState taskState = DNSState.ANNOUNCED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Renewer(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
        if (this._jmDNSImpl.getState() == DNSState.ANNOUNCED) {
            this._jmDNSImpl.setTask(this);
        }
        JmDNSImpl jmDNSImpl2 = this._jmDNSImpl;
        synchronized (jmDNSImpl2) {
            for (ServiceInfoImpl serviceInfoImpl : this._jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getState() != DNSState.ANNOUNCED) continue;
                serviceInfoImpl.setTask(this);
            }
        }
    }

    public void start(Timer timer) {
        if (this._jmDNSImpl.getState() != DNSState.CANCELED) {
            timer.schedule((TimerTask)this, 1800000L, 1800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        if (this._jmDNSImpl.getTask() == this) {
            this._jmDNSImpl.setTask(null);
        }
        JmDNSImpl jmDNSImpl = this._jmDNSImpl;
        synchronized (jmDNSImpl) {
            for (ServiceInfoImpl serviceInfoImpl : this._jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getTask() != this) continue;
                serviceInfoImpl.setTask(null);
            }
        }
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DNSOutgoing out = null;
        try {
            ArrayList<ServiceInfo> list;
            if (this._jmDNSImpl.getState() == this.taskState) {
                out = new DNSOutgoing(33792);
                this._jmDNSImpl.getLocalHost().addAddressRecords(out, false);
                this._jmDNSImpl.advanceState();
            }
            JmDNSImpl jmDNSImpl = this._jmDNSImpl;
            synchronized (jmDNSImpl) {
                list = new ArrayList<ServiceInfo>(this._jmDNSImpl.getServices().values());
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ServiceInfoImpl info;
                ServiceInfoImpl serviceInfoImpl = info = (ServiceInfoImpl)i.next();
                synchronized (serviceInfoImpl) {
                    if (info.getState() == this.taskState && info.getTask() == this) {
                        info.advanceState();
                        logger.finer("run() JmDNS announced " + info.getQualifiedName() + " state " + (Object)((Object)info.getState()));
                        if (out == null) {
                            out = new DNSOutgoing(33792);
                        }
                        info.addAnswers(out, 3600, this._jmDNSImpl.getLocalHost());
                    }
                }
            }
            if (out != null) {
                logger.finer("run() JmDNS announced");
                this._jmDNSImpl.send(out);
            } else {
                this.cancel();
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "run() exception ", e);
            this._jmDNSImpl.recover();
        }
        this.taskState = this.taskState.advance();
        if (!this.taskState.isAnnounced()) {
            this.cancel();
        }
    }
}

