/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class Responder
extends DNSTask {
    static Logger logger = Logger.getLogger(Responder.class.getName());
    private DNSIncoming _in;
    private boolean _unicast;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming in, int port) {
        super(jmDNSImpl);
        this._in = in;
        this._unicast = port != 5353;
    }

    public void start() {
        int n;
        int n2;
        boolean iAmTheOnlyOne = true;
        for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
            logger.finest("start() question=" + dNSQuestion);
            if (!(iAmTheOnlyOne &= DNSRecordType.TYPE_SRV.equals((Object)dNSQuestion.getRecordType()) || DNSRecordType.TYPE_TXT.equals((Object)dNSQuestion.getRecordType()) || DNSRecordType.TYPE_A.equals((Object)dNSQuestion.getRecordType()) || DNSRecordType.TYPE_AAAA.equals((Object)dNSQuestion.getRecordType()) || this._jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(dNSQuestion.getName()) || this._jmDNSImpl.getServices().containsKey(dNSQuestion.getName().toLowerCase()))) break;
        }
        int n3 = n2 = iAmTheOnlyOne && !this._in.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this._in.elapseSinceArrival();
        if (n2 < 0) {
            n = 0;
        }
        logger.finest("start() Responder chosen delay=" + n);
        this._jmDNSImpl.schedule(this, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        this._jmDNSImpl.ioLock();
        try {
            if (this._jmDNSImpl.getPlannedAnswer() == this._in) {
                this._jmDNSImpl.setPlannedAnswer(null);
            }
            HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
            HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
            if (this._jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                try {
                    for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
                        if (this._unicast) {
                            questions.add(dNSQuestion);
                        }
                        dNSQuestion.addAnswers(this._jmDNSImpl, answers);
                    }
                    for (DNSRecord dNSRecord : this._in.getAnswers()) {
                        if (dNSRecord.getTTL() <= 1800 || !answers.remove(dNSRecord)) continue;
                        logger.log(Level.FINER, "JmDNS Responder Known Answer Removed");
                    }
                    if (answers.size() != 0) {
                        void var3_8;
                        logger.finer("run() JmDNS responding");
                        DNSOutgoing dNSOutgoing = Responder.newDNSOutgoing(this._unicast, this._in.getId(), this._in.getSenderUDPPayload());
                        for (DNSQuestion question : questions) {
                            dNSOutgoing.addQuestion(question);
                        }
                        for (DNSRecord answer : answers) {
                            try {
                                var3_8.addAnswer(this._in, answer);
                            }
                            catch (IOException e) {
                                var3_8.setFlags(var3_8.getFlags() | 0x200);
                                this._jmDNSImpl.send((DNSOutgoing)var3_8);
                                DNSOutgoing dNSOutgoing2 = Responder.newDNSOutgoing(this._unicast, this._in.getId(), this._in.getSenderUDPPayload());
                                dNSOutgoing2.addAnswer(this._in, answer);
                            }
                        }
                        this._jmDNSImpl.send((DNSOutgoing)var3_8);
                    }
                    this.cancel();
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "run() exception ", throwable);
                    this._jmDNSImpl.close();
                }
            }
        }
        finally {
            this._jmDNSImpl.ioUnlock();
        }
    }

    private static final DNSOutgoing newDNSOutgoing(boolean isUnicast, int id, int senderUDPPayload) {
        DNSOutgoing out = new DNSOutgoing(33792, !isUnicast, senderUDPPayload);
        out.setId(id);
        return out;
    }
}

