/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class ServiceInfoResolver
extends DNSTask {
    static Logger logger = Logger.getLogger(ServiceInfoResolver.class.getName());
    int _count = 0;
    private final ServiceInfoImpl _info;

    public ServiceInfoResolver(JmDNSImpl jmDNSImpl, ServiceInfoImpl info) {
        super(jmDNSImpl);
        this._info = info;
        info.setDns(this._jmDNSImpl);
        this._jmDNSImpl.addListener(info, DNSQuestion.newQuestion(info.getQualifiedName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
    }

    public void start(Timer timer) {
        if (this._jmDNSImpl.getState() != DNSState.CANCELED) {
            timer.schedule((TimerTask)this, 225L, 225L);
        }
    }

    @Override
    public void run() {
        try {
            if (this._jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this._count++ < 3 && !this._info.hasData()) {
                    long now = System.currentTimeMillis();
                    DNSOutgoing out = new DNSOutgoing(0);
                    out.addQuestion(DNSQuestion.newQuestion(this._info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, false));
                    out.addQuestion(DNSQuestion.newQuestion(this._info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, false));
                    if (this._info.getServer() != null) {
                        out.addQuestion(DNSQuestion.newQuestion(this._info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN, false));
                        out.addQuestion(DNSQuestion.newQuestion(this._info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN, false));
                    }
                    out.addAnswer((DNSRecord)this._jmDNSImpl.getCache().getDNSEntry(this._info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN), now);
                    out.addAnswer((DNSRecord)this._jmDNSImpl.getCache().getDNSEntry(this._info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN), now);
                    if (this._info.getServer() != null) {
                        out.addAnswer((DNSRecord)this._jmDNSImpl.getCache().getDNSEntry(this._info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN), now);
                        out.addAnswer((DNSRecord)this._jmDNSImpl.getCache().getDNSEntry(this._info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN), now);
                    }
                    this._jmDNSImpl.send(out);
                } else {
                    this.cancel();
                    this._jmDNSImpl.removeListener(this._info);
                }
            } else if (this._jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
                this._jmDNSImpl.removeListener(this._info);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "run() exception ", e);
            this._jmDNSImpl.recover();
        }
    }
}

