/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.test;

import java.io.IOException;
import java.net.InetAddress;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import junit.framework.Assert;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class JmDNSTest {
    private ServiceTypeListener typeListenerMock;
    private ServiceListener serviceListenerMock;
    private ServiceInfo service;

    @Before
    public void setup() {
        this.service = ServiceInfo.create("_html._http._tcp.local.", "apache-someuniqueid", 80, "Test hypothetical web server");
        this.typeListenerMock = (ServiceTypeListener)EasyMock.createMock(ServiceTypeListener.class);
        this.serviceListenerMock = (ServiceListener)EasyMock.createMock(ServiceListener.class);
    }

    @Test
    public void testCreate() throws IOException {
        JmDNS registry = JmDNS.create();
        registry.close();
    }

    @Test
    public void testCreateINet() throws IOException {
        JmDNS registry = JmDNS.create(InetAddress.getLocalHost());
        registry.close();
    }

    @Test
    public void testRegisterService() throws IOException {
        JmDNS registry = null;
        try {
            registry = JmDNS.create();
            registry.registerService(this.service);
        }
        finally {
            if (registry != null) {
                registry.close();
            }
        }
    }

    @Test
    public void testQueryMyService() throws IOException {
        JmDNS registry = null;
        try {
            registry = JmDNS.create();
            registry.registerService(this.service);
            ServiceInfo queriedService = registry.getServiceInfo(this.service.getType(), this.service.getName());
            Assert.assertEquals((Object)this.service, (Object)queriedService);
        }
        finally {
            if (registry != null) {
                registry.close();
            }
        }
    }

    @Test
    public void testListMyService() throws IOException {
        JmDNS registry = null;
        try {
            registry = JmDNS.create();
            registry.registerService(this.service);
            ServiceInfo[] services = registry.list(this.service.getType());
            Assert.assertEquals((String)"We should see the service we just registered: ", (int)1, (int)services.length);
            Assert.assertEquals((Object)this.service, (Object)services[0]);
        }
        finally {
            if (registry != null) {
                registry.close();
            }
        }
    }

    @Test
    public void testListenForMyService() throws IOException {
        JmDNS registry = null;
        try {
            Capture capServiceAddedEvent = new Capture();
            Capture capServiceResolvedEvent = new Capture();
            this.serviceListenerMock.serviceAdded((ServiceEvent)EasyMock.capture((Capture)capServiceAddedEvent));
            this.serviceListenerMock.serviceResolved((ServiceEvent)EasyMock.capture((Capture)capServiceResolvedEvent));
            EasyMock.replay((Object[])new Object[]{this.serviceListenerMock});
            registry = JmDNS.create();
            registry.addServiceListener(this.service.getType(), this.serviceListenerMock);
            registry.registerService(this.service);
            Assert.assertTrue((String)"We did not get the service added event.", (boolean)capServiceAddedEvent.hasCaptured());
            Assert.assertTrue((String)"We did not get the service resolved event.", (boolean)capServiceResolvedEvent.hasCaptured());
            EasyMock.verify((Object[])new Object[]{this.serviceListenerMock});
            ServiceInfo result = ((ServiceEvent)capServiceResolvedEvent.getValue()).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)result);
        }
        finally {
            if (registry != null) {
                registry.close();
            }
        }
    }

    @Test
    public void testListenForMyServiceAndList() throws IOException {
        JmDNS registry = null;
        try {
            Capture capServiceAddedEvent = new Capture();
            Capture capServiceResolvedEvent = new Capture();
            this.serviceListenerMock.serviceAdded((ServiceEvent)EasyMock.capture((Capture)capServiceAddedEvent));
            this.serviceListenerMock.serviceResolved((ServiceEvent)EasyMock.capture((Capture)capServiceResolvedEvent));
            EasyMock.replay((Object[])new Object[]{this.serviceListenerMock});
            registry = JmDNS.create();
            registry.addServiceListener(this.service.getType(), this.serviceListenerMock);
            registry.registerService(this.service);
            Assert.assertTrue((String)"We did not get the service added event.", (boolean)capServiceAddedEvent.hasCaptured());
            ServiceInfo info = ((ServiceEvent)capServiceAddedEvent.getValue()).getInfo();
            ServiceInfo[] services = registry.list(info.getType());
            Assert.assertEquals((String)"We did not get the expected number of services: ", (int)1, (int)services.length);
            Assert.assertEquals((String)"The service returned was not the one expected", (Object)this.service, (Object)services[0]);
            Assert.assertTrue((String)"We did not get the service resolved event.", (boolean)capServiceResolvedEvent.hasCaptured());
            EasyMock.verify((Object[])new Object[]{this.serviceListenerMock});
            ServiceInfo result = ((ServiceEvent)capServiceResolvedEvent.getValue()).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)result);
        }
        finally {
            if (registry != null) {
                registry.close();
            }
        }
    }

    @Test
    public void testListenForServiceOnOtherRegistry() throws IOException {
        JmDNS registry = null;
        JmDNS newServiceRegistry = null;
        try {
            Capture capServiceAddedEvent = new Capture();
            Capture capServiceResolvedEvent = new Capture();
            this.serviceListenerMock.serviceAdded((ServiceEvent)EasyMock.capture((Capture)capServiceAddedEvent));
            this.serviceListenerMock.serviceResolved((ServiceEvent)EasyMock.capture((Capture)capServiceResolvedEvent));
            EasyMock.replay((Object[])new Object[]{this.serviceListenerMock});
            registry = JmDNS.create();
            registry.addServiceListener(this.service.getType(), this.serviceListenerMock);
            newServiceRegistry = JmDNS.create();
            newServiceRegistry.registerService(this.service);
            Assert.assertTrue((String)"We did not get the service added event.", (boolean)capServiceAddedEvent.hasCaptured());
            Assert.assertTrue((String)"We did not get the service resolved event.", (boolean)capServiceResolvedEvent.hasCaptured());
            EasyMock.verify((Object[])new Object[]{this.serviceListenerMock});
            ServiceInfo result = ((ServiceEvent)capServiceResolvedEvent.getValue()).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)result);
        }
        finally {
            if (registry != null) {
                registry.close();
            }
            if (newServiceRegistry != null) {
                newServiceRegistry.close();
            }
        }
    }

    @Test
    public void testWaitAndQueryForServiceOnOtherRegistry() throws IOException {
        JmDNS registry = null;
        JmDNS newServiceRegistry = null;
        try {
            newServiceRegistry = JmDNS.create();
            registry = JmDNS.create();
            registry.registerService(this.service);
            ServiceInfo fetchedService = newServiceRegistry.getServiceInfo(this.service.getType(), this.service.getName());
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)fetchedService);
        }
        finally {
            if (registry != null) {
                registry.close();
            }
            if (newServiceRegistry != null) {
                newServiceRegistry.close();
            }
        }
    }

    @Test
    public void testRegisterAndListServiceOnOtherRegistry() throws IOException {
        JmDNS registry = null;
        JmDNS newServiceRegistry = null;
        try {
            registry = JmDNS.create("Registry");
            registry.registerService(this.service);
            newServiceRegistry = JmDNS.create("Listener");
            ServiceInfo[] fetchedServices = newServiceRegistry.list(this.service.getType());
            Assert.assertEquals((String)"Did not get the expected services listed:", (int)1, (int)fetchedServices.length);
            Assert.assertEquals((String)"Did not get the expected service type:", (String)this.service.getType(), (String)fetchedServices[0].getType());
            Assert.assertEquals((String)"Did not get the expected service name:", (String)this.service.getName(), (String)fetchedServices[0].getName());
            Assert.assertEquals((String)"Did not get the expected service fully qualified name:", (String)this.service.getQualifiedName(), (String)fetchedServices[0].getQualifiedName());
            newServiceRegistry.getServiceInfo(this.service.getType(), this.service.getName());
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)fetchedServices[0]);
            registry.close();
            fetchedServices = newServiceRegistry.list(this.service.getType());
            Assert.assertEquals((String)"The service was not cancelled after the close:", (int)0, (int)fetchedServices.length);
        }
        finally {
            if (newServiceRegistry != null) {
                newServiceRegistry.close();
            }
            if (registry != null) {
                registry.close();
            }
        }
    }
}

