/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;

class SocketListener
implements Runnable {
    static Logger logger = Logger.getLogger(SocketListener.class.getName());
    private final JmDNSImpl _jmDNSImpl;

    SocketListener(JmDNSImpl jmDNSImpl) {
        this._jmDNSImpl = jmDNSImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block12: {
            try {
                byte[] buf = new byte[8972];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (!this._jmDNSImpl.isCanceling() && !this._jmDNSImpl.isCanceled()) {
                    packet.setLength(buf.length);
                    this._jmDNSImpl.getSocket().receive(packet);
                    if (!this._jmDNSImpl.isCanceling() && !this._jmDNSImpl.isCanceled()) {
                        try {
                            if (this._jmDNSImpl.getLocalHost().shouldIgnorePacket(packet)) continue;
                            DNSIncoming msg = new DNSIncoming(packet);
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest(this.getName() + ".run() JmDNS in:" + msg.print(true));
                            }
                            if (msg.isQuery()) {
                                if (packet.getPort() != DNSConstants.MDNS_PORT) {
                                    this._jmDNSImpl.handleQuery(msg, packet.getAddress(), packet.getPort());
                                }
                                this._jmDNSImpl.handleQuery(msg, this._jmDNSImpl.getGroup(), DNSConstants.MDNS_PORT);
                                continue;
                            }
                            this._jmDNSImpl.handleResponse(msg);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, this.getName() + ".run() exception ", e);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this._jmDNSImpl.isCanceling() || this._jmDNSImpl.isCanceled()) break block12;
                logger.log(Level.WARNING, this.getName() + ".run() exception ", e);
                this._jmDNSImpl.recover();
            }
        }
        JmDNSImpl jmDNSImpl = this._jmDNSImpl;
        synchronized (jmDNSImpl) {
            this._jmDNSImpl.notifyAll();
        }
    }

    public String getName() {
        return "SocketListener(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    public JmDNSImpl getDns() {
        return this._jmDNSImpl;
    }
}

