/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.jnlp;

import hudson.remoting.Engine;
import hudson.remoting.EngineListener;
import hudson.remoting.jnlp.GuiListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main {
    @Option(name="-tunnel", metaVar="HOST:PORT", usage="Connect to the specified host and port, instead of connecting directly to Hudson. Useful when connection to Hudson needs to be tunneled. Can be also HOST: or :PORT, in which case the missing portion will be auto-configured like the default behavior")
    public String tunnel;
    @Option(name="-headless", usage="Run in headless mode, without GUI")
    public boolean headlessMode = Boolean.getBoolean("hudson.agent.headless") || Boolean.getBoolean("hudson.webstart.headless");
    @Option(name="-url", usage="Specify the Hudson root URLs to connect to.")
    public final List<URL> urls = new ArrayList<URL>();
    @Argument
    public final List<String> args = new ArrayList<String>();
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws IOException {
        try {
            System.setSecurityManager(null);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Main m = new Main();
        CmdLineParser p = new CmdLineParser(m);
        try {
            p.parseArgument(args);
            if (m.args.size() != 2) {
                throw new CmdLineException("two arguments required, but got " + m.args);
            }
            if (m.urls.isEmpty()) {
                throw new CmdLineException("At least one -url option is required.");
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar slave.jar [options...] <secret key> <slave name>");
            p.printUsage(System.err);
            return;
        }
        m.main();
    }

    public void main() throws IOException {
        Engine engine = new Engine(this.headlessMode ? new CuiListener() : new GuiListener(), this.urls, this.args.get(0), this.args.get(1));
        if (this.tunnel != null) {
            engine.setTunnel(this.tunnel);
        }
        engine.start();
    }

    private static final class CuiListener
    implements EngineListener {
        private CuiListener() {
            LOGGER.info("Hudson agent is running in headless mode.");
        }

        public void status(String msg) {
            LOGGER.info(msg);
        }

        public void error(Throwable t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            System.exit(-1);
        }

        public void onDisconnect() {
        }
    }
}

