/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;

public class FullDuplexHttpStream {
    private final URL target;
    private final UUID uuid = UUID.randomUUID();
    private final OutputStream output;
    private final InputStream input;
    static final int BLOCK_SIZE = 1024;

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public FullDuplexHttpStream(URL target) throws IOException {
        this.target = target;
        HttpURLConnection con = (HttpURLConnection)target.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.addRequestProperty("Session", this.uuid.toString());
        con.addRequestProperty("Side", "download");
        con.getOutputStream().close();
        this.input = con.getInputStream();
        if (con.getHeaderField("Hudson-Duplex") == null) {
            throw new IOException(target + " doesn't look like Hudson");
        }
        con = (HttpURLConnection)target.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setChunkedStreamingMode(0);
        con.addRequestProperty("Session", this.uuid.toString());
        con.addRequestProperty("Side", "upload");
        this.output = con.getOutputStream();
    }
}

