/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.CliEntryPoint;
import hudson.cli.FullDuplexHttpStream;
import hudson.cli.Messages;
import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CLI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] _args) throws Exception {
        String head;
        List<String> args = Arrays.asList(_args);
        String url = System.getenv("HUDSON_URL");
        while (!args.isEmpty() && (head = args.get(0)).equals("-s") && args.size() >= 2) {
            url = args.get(1);
            args = args.subList(2, args.size());
        }
        if (url == null) {
            CLI.printUsageAndExit(Messages.CLI_NoURL());
        }
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        url = url + "cli";
        if (args.isEmpty()) {
            args = Arrays.asList("help");
        }
        FullDuplexHttpStream con = new FullDuplexHttpStream(new URL(url));
        ExecutorService pool = Executors.newCachedThreadPool();
        Channel channel = new Channel("Chunked connection to " + url, pool, con.getInputStream(), con.getOutputStream());
        new PingThread(channel, 30000L){

            protected void onDead() {
            }
        }.start();
        int r = -1;
        try {
            CliEntryPoint cli = (CliEntryPoint)channel.waitForRemoteProperty((Object)CliEntryPoint.class.getName());
            if (cli.protocolVersion() != 1) {
                System.err.println(Messages.CLI_VersionMismatch());
            } else {
                args = new ArrayList<String>(args);
                r = cli.main(args, Locale.getDefault(), (InputStream)new RemoteInputStream(System.in), (OutputStream)new RemoteOutputStream((OutputStream)System.out), (OutputStream)new RemoteOutputStream((OutputStream)System.err));
            }
        }
        finally {
            channel.close();
            pool.shutdown();
        }
        System.exit(r);
    }

    private static void printUsageAndExit(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.err.println(Messages.CLI_Usage());
        System.exit(-1);
    }
}

