/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncFutureImpl<V>
implements Future<V> {
    private V value;
    private Throwable problem;
    private boolean completed;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.completed;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            this.wait();
        }
        if (this.problem != null) {
            throw new ExecutionException(this.problem);
        }
        return this.value;
    }

    @Override
    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.completed) {
            this.wait(unit.toMillis(timeout));
        }
        if (!this.completed) {
            throw new TimeoutException();
        }
        return this.get();
    }

    public synchronized void set(V value) {
        this.completed = true;
        this.value = value;
        this.notifyAll();
    }

    public synchronized void set(Throwable problem) {
        this.completed = true;
        this.problem = problem;
        this.notifyAll();
    }
}

