/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.BinarySafeStream;
import hudson.remoting.Callable;
import hudson.remoting.Command;
import hudson.remoting.ExportTable;
import hudson.remoting.Future;
import hudson.remoting.FutureAdapter;
import hudson.remoting.GCCommand;
import hudson.remoting.IChannel;
import hudson.remoting.ImportedClassLoaderTable;
import hudson.remoting.PreloadJarTask;
import hudson.remoting.RemoteInvocationHandler;
import hudson.remoting.Request;
import hudson.remoting.UserRequest;
import hudson.remoting.UserResponse;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.remoting.forward.ForwarderFactory;
import hudson.remoting.forward.ListeningPort;
import hudson.remoting.forward.PortForwarder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
implements VirtualChannel,
IChannel {
    private final ObjectInputStream ois;
    private final ObjectOutputStream oos;
    private final String name;
    final boolean isRestricted;
    final ExecutorService executor;
    private volatile boolean inClosed = false;
    private volatile boolean outClosed = false;
    final Map<Integer, Request<?, ?>> pendingCalls = new Hashtable();
    final Map<Integer, Request<?, ?>> executingCalls = Collections.synchronizedMap(new Hashtable());
    final ImportedClassLoaderTable importedClassLoaders = new ImportedClassLoaderTable(this);
    private final ExportTable<Object> exportedObjects = new ExportTable();
    private final Vector<Listener> listeners = new Vector();
    private int gcCounter;
    public final AtomicLong classLoadingTime = new AtomicLong();
    public final AtomicInteger classLoadingCount = new AtomicInteger();
    public final AtomicLong resourceLoadingTime = new AtomicLong();
    public final AtomicInteger resourceLoadingCount = new AtomicInteger();
    private final Hashtable<Object, Object> properties = new Hashtable();
    private IChannel remoteChannel;
    private static final ThreadLocal<Channel> CURRENT = new ThreadLocal();
    private static final Logger logger = Logger.getLogger(Channel.class.getName());

    public Channel(String name, ExecutorService exec, InputStream is, OutputStream os) throws IOException {
        this(name, exec, Mode.BINARY, is, os, null);
    }

    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os) throws IOException {
        this(name, exec, mode, is, os, null);
    }

    public Channel(String name, ExecutorService exec, InputStream is, OutputStream os, OutputStream header) throws IOException {
        this(name, exec, Mode.BINARY, is, os, header);
    }

    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header) throws IOException {
        this(name, exec, mode, is, os, header, false);
    }

    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header, boolean restricted) throws IOException {
        this.name = name;
        this.executor = exec;
        this.isRestricted = restricted;
        ObjectOutputStream oos = null;
        if (this.export(this, false) != 1) {
            throw new AssertionError();
        }
        this.remoteChannel = RemoteInvocationHandler.wrap(this, 1, IChannel.class, false);
        if (mode != Mode.NEGOTIATE) {
            os.write(mode.preamble);
            oos = new ObjectOutputStream(mode.wrap(os));
            oos.flush();
        }
        int[] ptr = new int[2];
        Mode[] modes = new Mode[]{Mode.BINARY, Mode.TEXT};
        while (true) {
            int ch;
            if ((ch = is.read()) == -1) {
                throw new EOFException("unexpected stream termination");
            }
            for (int i = 0; i < 2; ++i) {
                byte[] preamble = modes[i].preamble;
                if (preamble[ptr[i]] == ch) {
                    int n = i;
                    ptr[n] = ptr[n] + 1;
                    if (ptr[n] != preamble.length) continue;
                    if (mode == Mode.NEGOTIATE) {
                        mode = modes[i];
                        os.write(mode.preamble);
                        oos = new ObjectOutputStream(mode.wrap(os));
                        oos.flush();
                    } else if (modes[i] != mode) {
                        throw new IOException("Protocol negotiation failure");
                    }
                    this.oos = oos;
                    this.ois = new ObjectInputStream(mode.wrap(is));
                    new ReaderThread(name).start();
                    return;
                }
                ptr[i] = 0;
            }
            if (header == null) continue;
            header.write(ch);
        }
    }

    boolean isOutClosed() {
        return this.outClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void send(Command cmd) throws IOException {
        if (this.outClosed) {
            throw new IOException("already closed");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Send " + cmd);
        }
        Channel old = Channel.setCurrent(this);
        try {
            this.oos.writeObject(cmd);
            this.oos.flush();
        }
        finally {
            Channel.setCurrent(old);
        }
        if (!(cmd instanceof CloseCommand)) {
            this.oos.reset();
        }
    }

    @Override
    public <T> T export(Class<T> type, T instance) {
        return this.export(type, instance, true);
    }

    <T> T export(Class<T> type, T instance, boolean userProxy) {
        if (instance == null) {
            return null;
        }
        if (++this.gcCounter % 10000 == 0) {
            try {
                this.send(new GCCommand());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to send GC command", e);
            }
        }
        int id = this.export(instance);
        return RemoteInvocationHandler.wrap(null, id, type, userProxy);
    }

    int export(Object instance) {
        return this.exportedObjects.export(instance);
    }

    int export(Object instance, boolean automaticUnexport) {
        return this.exportedObjects.export(instance, automaticUnexport);
    }

    Object getExportedObject(int oid) {
        return this.exportedObjects.get(oid);
    }

    void unexport(int id) {
        this.exportedObjects.unexport(id);
    }

    public boolean preloadJar(Callable<?, ?> classLoaderRef, Class ... classesInJar) throws IOException, InterruptedException {
        return this.preloadJar(UserRequest.getClassLoader(classLoaderRef), classesInJar);
    }

    public boolean preloadJar(ClassLoader local, Class ... classesInJar) throws IOException, InterruptedException {
        URL[] jars = new URL[classesInJar.length];
        for (int i = 0; i < classesInJar.length; ++i) {
            jars[i] = Which.jarFile(classesInJar[i]).toURI().toURL();
        }
        return this.call(new PreloadJarTask(jars, local));
    }

    @Override
    public <V, T extends Throwable> V call(Callable<V, T> callable) throws IOException, T, InterruptedException {
        UserRequest request = null;
        try {
            request = new UserRequest(this, callable);
            UserResponse r = (UserResponse)request.call(this);
            Object RSP = r.retrieve(this, UserRequest.getClassLoader(callable));
            return (V)RSP;
        }
        catch (ClassNotFoundException e) {
            IOException x = new IOException("Remote call failed");
            x.initCause(e);
            throw x;
        }
        catch (Error e) {
            IOException x = new IOException("Remote call failed");
            x.initCause(e);
            throw x;
        }
        finally {
            if (request != null) {
                request.releaseExports();
            }
        }
    }

    @Override
    public <V, T extends Throwable> Future<V> callAsync(final Callable<V, T> callable) throws IOException {
        Future f = new UserRequest(this, callable).callAsync(this);
        return new FutureAdapter<V, UserResponse<V, T>>(f){

            @Override
            protected V adapt(UserResponse<V, T> r) throws ExecutionException {
                try {
                    return r.retrieve(Channel.this, UserRequest.getClassLoader(callable));
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void terminate(IOException e) {
        this.inClosed = true;
        this.outClosed = true;
        try {
            Map<Integer, Request<?, ?>> map = this.pendingCalls;
            synchronized (map) {
                for (Request<?, ?> req : this.pendingCalls.values()) {
                    req.abort(e);
                }
                this.pendingCalls.clear();
            }
            map = this.executingCalls;
            synchronized (map) {
                for (Request<?, ?> r : this.executingCalls.values()) {
                    java.util.concurrent.Future<?> f = r.future;
                    if (f == null) continue;
                    f.cancel(true);
                }
                this.executingCalls.clear();
            }
        }
        finally {
            this.notifyAll();
            for (Listener l : this.listeners.toArray(new Listener[this.listeners.size()])) {
                l.onClosed(this, e);
            }
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.listeners.remove(l);
    }

    @Override
    public synchronized void join() throws InterruptedException {
        while (!this.inClosed || !this.outClosed) {
            this.wait();
        }
    }

    @Override
    public synchronized void join(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= timeout || this.inClosed && this.outClosed)) {
            this.wait(timeout + start - System.currentTimeMillis());
        }
    }

    public void resetPerformanceCounters() {
        this.classLoadingCount.set(0);
        this.classLoadingTime.set(0L);
        this.resourceLoadingCount.set(0);
        this.resourceLoadingTime.set(0L);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.outClosed) {
            return;
        }
        this.send(new CloseCommand());
        this.outClosed = true;
        try {
            this.oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Object waitForProperty(Object key) throws InterruptedException {
        Hashtable<Object, Object> hashtable = this.properties;
        synchronized (hashtable) {
            while (true) {
                Object v;
                if ((v = this.properties.get(key)) != null) {
                    return v;
                }
                this.properties.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(Object key, Object value) {
        Hashtable<Object, Object> hashtable = this.properties;
        synchronized (hashtable) {
            Object old = this.properties.put(key, value);
            this.properties.notifyAll();
            return old;
        }
    }

    public Object getRemoteProperty(Object key) {
        return this.remoteChannel.getProperty(key);
    }

    public Object waitForRemoteProperty(Object key) throws InterruptedException {
        return this.remoteChannel.waitForProperty(key);
    }

    public ListeningPort createLocalToRemotePortForwarding(int recvPort, String forwardHost, int forwardPort) throws IOException, InterruptedException {
        return new PortForwarder(recvPort, ForwarderFactory.create(this, forwardHost, forwardPort));
    }

    public ListeningPort createRemoteToLocalPortForwarding(int recvPort, String forwardHost, int forwardPort) throws IOException, InterruptedException {
        return PortForwarder.create(this, recvPort, ForwarderFactory.create(forwardHost, forwardPort));
    }

    public String toString() {
        return super.toString() + ":" + this.name;
    }

    public void dumpExportTable(PrintWriter w) throws IOException {
        this.exportedObjects.dump(w);
    }

    public ExportTable.ExportList startExportRecording() {
        return this.exportedObjects.startRecording();
    }

    static Channel setCurrent(Channel channel) {
        Channel old = CURRENT.get();
        CURRENT.set(channel);
        return old;
    }

    public static Channel current() {
        return CURRENT.get();
    }

    private final class ReaderThread
    extends Thread {
        public ReaderThread(String name) {
            super("Channel reader thread: " + name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Command cmd = null;
            try {
                while (!Channel.this.inClosed) {
                    try {
                        Channel old = Channel.setCurrent(Channel.this);
                        try {
                            cmd = (Command)Channel.this.ois.readObject();
                        }
                        finally {
                            Channel.setCurrent(old);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.log(Level.SEVERE, "Unable to read a command", e);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Received " + cmd);
                    }
                    try {
                        cmd.execute(Channel.this);
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "Failed to execute command " + cmd, t);
                        logger.log(Level.SEVERE, "This command is created here", cmd.createdAt);
                    }
                }
                Channel.this.ois.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "I/O error in channel " + Channel.this.name, e);
                Channel.this.terminate(e);
            }
        }
    }

    private static final class OrderlyShutdown
    extends IOException {
        private static final long serialVersionUID = 1L;

        private OrderlyShutdown(Throwable cause) {
            super(cause.getMessage());
            this.initCause(cause);
        }
    }

    private static final class CloseCommand
    extends Command {
        private CloseCommand() {
        }

        protected void execute(Channel channel) {
            try {
                channel.close();
                channel.terminate(new OrderlyShutdown(this.createdAt));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "close command failed on " + channel.name, e);
                logger.log(Level.INFO, "close command created at", this.createdAt);
            }
        }

        public String toString() {
            return "close";
        }
    }

    public static abstract class Listener {
        public void onClosed(Channel channel, IOException cause) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        BINARY(new byte[]{0, 0, 0, 0}),
        TEXT("<===[HUDSON TRANSMISSION BEGINS]===>"){

            protected OutputStream wrap(OutputStream os) {
                return BinarySafeStream.wrap(os);
            }

            protected InputStream wrap(InputStream is) {
                return BinarySafeStream.wrap(is);
            }
        }
        ,
        NEGOTIATE(new byte[0]);

        private final byte[] preamble;

        private Mode(String preamble) {
            try {
                this.preamble = preamble.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }

        private Mode(byte[] preamble) {
            this.preamble = preamble;
        }

        protected OutputStream wrap(OutputStream os) {
            return os;
        }

        protected InputStream wrap(InputStream is) {
            return is;
        }
    }
}

