/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExportTable<T> {
    private final Map<Integer, Entry> table = new HashMap<Integer, Entry>();
    private final Map<T, Entry> reverse = new HashMap<T, Entry>();
    private final ThreadLocal<List<ExportList>> lists = new ThreadLocal<List<ExportList>>(){

        @Override
        protected List<ExportList> initialValue() {
            return new ArrayList<ExportList>();
        }
    };
    private int iota = 1;

    ExportTable() {
    }

    public synchronized ExportList startRecording() {
        ExportList el = new ExportList();
        this.lists.get().add(el);
        return el;
    }

    public synchronized int export(T t) {
        return this.export(t, true);
    }

    public synchronized int export(T t, boolean notifyListener) {
        if (t == null) {
            return 0;
        }
        Entry e = this.reverse.get(t);
        if (e == null) {
            e = new Entry(t);
        } else {
            e.addRef();
        }
        if (notifyListener) {
            for (ExportList list : this.lists.get()) {
                list.add(e);
            }
        }
        return e.id;
    }

    public synchronized T get(int id) {
        Entry e = this.table.get(id);
        if (e != null) {
            return e.object;
        }
        return null;
    }

    public synchronized void unexport(T t) {
        if (t == null) {
            return;
        }
        Entry e = this.reverse.get(t);
        if (e == null) {
            return;
        }
        e.release();
    }

    public synchronized void unexportByOid(Integer oid) {
        if (oid == null) {
            return;
        }
        Entry e = this.table.get(oid);
        if (e == null) {
            return;
        }
        e.release();
    }

    public synchronized void dump(PrintWriter w) throws IOException {
        for (Entry e : this.table.values()) {
            w.printf("#%d (ref.%d) : %s\n", e.id, e.referenceCount, e.object);
            e.allocationTrace.printStackTrace(w);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ExportList
    extends ArrayList<Entry> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            ExportTable exportTable = ExportTable.this;
            synchronized (exportTable) {
                for (Entry e : this) {
                    e.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopRecording() {
            ExportTable exportTable = ExportTable.this;
            synchronized (exportTable) {
                ((List)ExportTable.this.lists.get()).remove(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Entry {
        final int id;
        final T object;
        final Exception allocationTrace;
        private int referenceCount;

        Entry(T object) {
            this.id = ExportTable.this.iota++;
            this.object = object;
            this.allocationTrace = new Exception();
            this.allocationTrace.getStackTrace();
            this.addRef();
            ExportTable.this.table.put(this.id, this);
            ExportTable.this.reverse.put(object, this);
        }

        void addRef() {
            ++this.referenceCount;
        }

        void release() {
            if (--this.referenceCount == 0) {
                ExportTable.this.table.remove(this.id);
                ExportTable.this.reverse.remove(this.object);
            }
        }
    }
}

