/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.CliEntryPoint;
import hudson.cli.FullDuplexHttpStream;
import hudson.cli.Messages;
import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLI {
    private final ExecutorService pool;
    private final Channel channel;
    private final CliEntryPoint entryPoint;
    private final boolean ownsPool;
    private static final Logger LOGGER = Logger.getLogger(CLI.class.getName());

    public CLI(URL hudson) throws IOException, InterruptedException {
        this(hudson, null);
    }

    public CLI(URL hudson, ExecutorService exec) throws IOException, InterruptedException {
        String url = hudson.toExternalForm();
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        this.ownsPool = exec == null;
        this.pool = exec != null ? exec : Executors.newCachedThreadPool();
        int clip = this.getCliTcpPort(url);
        if (clip >= 0) {
            String host = new URL(url).getHost();
            LOGGER.fine("Trying to connect directly via TCP/IP to port " + clip + " of " + host);
            Socket s = new Socket(host, clip);
            DataOutputStream dos = new DataOutputStream(s.getOutputStream());
            dos.writeUTF("Protocol:CLI-connect");
            this.channel = new Channel("channel", this.pool, new BufferedInputStream(s.getInputStream()), new BufferedOutputStream(s.getOutputStream()));
        } else {
            LOGGER.fine("Trying to connect to " + url + " via HTTP");
            url = url + "cli";
            hudson = new URL(url);
            FullDuplexHttpStream con = new FullDuplexHttpStream(hudson);
            this.channel = new Channel("Chunked connection to " + hudson, this.pool, con.getInputStream(), con.getOutputStream());
            new PingThread(this.channel, 30000L){

                protected void onDead() {
                }
            }.start();
        }
        this.entryPoint = (CliEntryPoint)this.channel.waitForRemoteProperty(CliEntryPoint.class.getName());
        if (this.entryPoint.protocolVersion() != 1) {
            throw new IOException(Messages.CLI_VersionMismatch());
        }
    }

    private int getCliTcpPort(String url) throws IOException {
        URLConnection head = new URL(url).openConnection();
        head.connect();
        String p = head.getHeaderField("X-Hudson-CLI-Port");
        if (p == null) {
            return -1;
        }
        return Integer.parseInt(p);
    }

    public void close() throws IOException, InterruptedException {
        this.channel.close();
        this.channel.join();
        if (this.ownsPool) {
            this.pool.shutdown();
        }
    }

    public int execute(List<String> args, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        return this.entryPoint.main(args, Locale.getDefault(), new RemoteInputStream(stdin), new RemoteOutputStream(stdout), new RemoteOutputStream(stderr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] _args) throws Exception {
        String head;
        List<String> args = Arrays.asList(_args);
        String url = System.getenv("HUDSON_URL");
        while (!args.isEmpty() && (head = args.get(0)).equals("-s") && args.size() >= 2) {
            url = args.get(1);
            args = args.subList(2, args.size());
        }
        if (url == null) {
            CLI.printUsageAndExit(Messages.CLI_NoURL());
            return;
        }
        if (args.isEmpty()) {
            args = Arrays.asList("help");
        }
        CLI cli = new CLI(new URL(url));
        try {
            args = new ArrayList<String>(args);
            System.exit(cli.execute(args, System.in, System.out, System.err));
        }
        finally {
            cli.close();
        }
    }

    private static void printUsageAndExit(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.err.println(Messages.CLI_Usage());
        System.exit(-1);
    }
}

