/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.DelegatingCallable;
import hudson.remoting.RemoteClassLoader;
import java.io.IOException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PreloadJarTask
implements DelegatingCallable<Boolean, IOException> {
    private final URL[] jars;
    private transient ClassLoader target;

    PreloadJarTask(URL[] jars, ClassLoader target) {
        this.jars = jars;
        this.target = target;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.target;
    }

    @Override
    public Boolean call() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!(cl instanceof RemoteClassLoader)) {
            return false;
        }
        RemoteClassLoader rcl = (RemoteClassLoader)cl;
        boolean r = false;
        for (URL jar : this.jars) {
            r |= rcl.prefetch(jar);
        }
        return r;
    }
}

