/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.RemoteClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MultiClassLoaderSerializer {
    MultiClassLoaderSerializer() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Input
    extends ObjectInputStream {
        private final Channel channel;
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

        Input(Channel channel, InputStream in) throws IOException {
            super(in);
            this.channel = channel;
        }

        private ClassLoader readClassLoader() throws IOException, ClassNotFoundException {
            int code = this.readInt();
            switch (code) {
                case -2: {
                    return null;
                }
                case -1: {
                    this.classLoaders.add(Channel.class.getClassLoader());
                    ClassLoader cl = this.channel.importedClassLoaders.get((RemoteClassLoader.IClassLoader)this.readObject());
                    this.classLoaders.set(this.classLoaders.size() - 1, cl);
                    return cl;
                }
            }
            return this.classLoaders.get(code);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                ClassLoader cl = this.readClassLoader();
                Class<?> c = Class.forName(name, false, cl);
                return c;
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader cl = this.readClassLoader();
            Class[] classes = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                classes[i] = Class.forName(interfaces[i], false, cl);
            }
            return Proxy.getProxyClass(cl, classes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Output
    extends ObjectOutputStream {
        private final Channel channel;
        private final Map<ClassLoader, Integer> classLoaders = new HashMap<ClassLoader, Integer>();

        Output(Channel channel, OutputStream out) throws IOException {
            super(out);
            this.channel = channel;
        }

        @Override
        protected void annotateClass(Class<?> c) throws IOException {
            ClassLoader cl = c.getClassLoader();
            if (cl == null) {
                this.writeInt(-2);
                return;
            }
            Integer idx = this.classLoaders.get(cl);
            if (idx == null) {
                this.classLoaders.put(cl, this.classLoaders.size());
                this.writeInt(-1);
                this.writeObject(RemoteClassLoader.export(cl, this.channel));
            } else {
                this.writeInt(idx);
            }
        }

        @Override
        protected void annotateProxyClass(Class<?> cl) throws IOException {
            this.annotateClass(cl);
        }
    }
}

