/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.RemoteInvocationHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteClassLoader
extends URLClassLoader {
    private final IClassLoader proxy;
    private final Channel channel;
    private final Map<String, File> resourceMap = new HashMap<String, File>();
    private final Map<String, Vector<File>> resourcesMap = new HashMap<String, Vector<File>>();
    private final Set<URL> prefetchedJars = new HashSet<URL>();

    public static ClassLoader create(ClassLoader parent, IClassLoader proxy) {
        if (proxy instanceof ClassLoaderProxy) {
            return ((ClassLoaderProxy)proxy).cl;
        }
        return new RemoteClassLoader(parent, proxy);
    }

    private RemoteClassLoader(ClassLoader parent, IClassLoader proxy) {
        super(new URL[0], parent);
        this.proxy = proxy;
        this.channel = RemoteInvocationHandler.unwrap(proxy);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.channel.isRestricted) {
                throw e;
            }
            long startTime = System.nanoTime();
            byte[] bytes = this.proxy.fetch(name);
            this.channel.classLoadingTime.addAndGet(System.nanoTime() - startTime);
            this.channel.classLoadingCount.incrementAndGet();
            this.definePackage(name);
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }

    private void definePackage(String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return;
        }
        String packageName = name.substring(0, idx);
        if (this.getPackage(packageName) != null) {
            return;
        }
        this.definePackage(packageName, null, null, null, null, null, null, null);
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null || this.channel.isRestricted) {
            return url;
        }
        try {
            if (this.resourceMap.containsKey(name)) {
                File f = this.resourceMap.get(name);
                if (f == null) {
                    return null;
                }
                if (f.exists()) {
                    return f.toURI().toURL();
                }
            }
            long startTime = System.nanoTime();
            byte[] image = this.proxy.getResource(name);
            this.channel.resourceLoadingTime.addAndGet(System.nanoTime() - startTime);
            this.channel.resourceLoadingCount.incrementAndGet();
            if (image == null) {
                this.resourceMap.put(name, null);
                return null;
            }
            File res = this.makeResource(name, image);
            this.resourceMap.put(name, res);
            return res.toURI().toURL();
        }
        catch (IOException e) {
            throw new Error("Unable to load resource " + name, e);
        }
    }

    private static Vector<URL> toURLs(Vector<File> files) throws MalformedURLException {
        Vector<URL> r = new Vector<URL>(files.size());
        for (File f : files) {
            if (!f.exists()) {
                return null;
            }
            r.add(f.toURI().toURL());
        }
        return r;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> urls;
        if (this.channel.isRestricted) {
            return new Vector().elements();
        }
        Vector<File> files = this.resourcesMap.get(name);
        if (files != null && (urls = RemoteClassLoader.toURLs(files)) != null) {
            return urls.elements();
        }
        long startTime = System.nanoTime();
        byte[][] images = this.proxy.getResources(name);
        this.channel.resourceLoadingTime.addAndGet(System.nanoTime() - startTime);
        this.channel.resourceLoadingCount.incrementAndGet();
        files = new Vector();
        for (byte[] image : images) {
            files.add(this.makeResource(name, image));
        }
        this.resourcesMap.put(name, files);
        return RemoteClassLoader.toURLs(files).elements();
    }

    private File makeResource(String name, byte[] image) throws IOException {
        int idx = name.lastIndexOf(47);
        File f = File.createTempFile("hudson-remoting", "." + name.substring(idx + 1));
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(image);
        fos.close();
        f.deleteOnExit();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prefetch(URL jar) throws IOException {
        Set<URL> set = this.prefetchedJars;
        synchronized (set) {
            if (this.prefetchedJars.contains(jar)) {
                return false;
            }
            String p = jar.getPath().replace('\\', '/');
            p = p.substring(p.lastIndexOf(47) + 1);
            File localJar = this.makeResource(p, this.proxy.fetchJar(jar));
            this.addURL(localJar.toURI().toURL());
            this.prefetchedJars.add(jar);
            return true;
        }
    }

    public static IClassLoader export(ClassLoader cl, Channel local) {
        if (cl instanceof RemoteClassLoader) {
            RemoteClassLoader rcl = (RemoteClassLoader)cl;
            int oid = RemoteInvocationHandler.unwrap(rcl.proxy, local);
            if (oid != -1) {
                return new RemoteIClassLoader(oid, rcl.proxy);
            }
        }
        return local.export(IClassLoader.class, new ClassLoaderProxy(cl), false);
    }

    static int exportId(ClassLoader cl, Channel local) {
        return local.export(new ClassLoaderProxy(cl));
    }

    private static class RemoteIClassLoader
    implements IClassLoader,
    Serializable {
        private final transient IClassLoader proxy;
        private final int oid;
        private static final long serialVersionUID = 1L;

        private RemoteIClassLoader(int oid, IClassLoader proxy) {
            this.proxy = proxy;
            this.oid = oid;
        }

        public byte[] fetchJar(URL url) throws IOException {
            return this.proxy.fetchJar(url);
        }

        public byte[] fetch(String className) throws ClassNotFoundException {
            return this.proxy.fetch(className);
        }

        public byte[] getResource(String name) throws IOException {
            return this.proxy.getResource(name);
        }

        public byte[][] getResources(String name) throws IOException {
            return this.proxy.getResources(name);
        }

        private Object readResolve() {
            return Channel.current().getExportedObject(this.oid);
        }
    }

    static final class ClassLoaderProxy
    implements IClassLoader {
        private final ClassLoader cl;

        public ClassLoaderProxy(ClassLoader cl) {
            this.cl = cl;
        }

        public byte[] fetchJar(URL url) throws IOException {
            return this.readFully(url.openStream());
        }

        public byte[] fetch(String className) throws ClassNotFoundException {
            InputStream in = this.cl.getResourceAsStream(className.replace('.', '/') + ".class");
            if (in == null) {
                throw new ClassNotFoundException(className);
            }
            try {
                return this.readFully(in);
            }
            catch (IOException e) {
                throw new ClassNotFoundException();
            }
        }

        public byte[] getResource(String name) throws IOException {
            InputStream in = this.cl.getResourceAsStream(name);
            if (in == null) {
                return null;
            }
            return this.readFully(in);
        }

        public byte[][] getResources(String name) throws IOException {
            ArrayList<byte[]> images = new ArrayList<byte[]>();
            Enumeration<URL> e = this.cl.getResources(name);
            while (e.hasMoreElements()) {
                images.add(this.readFully(e.nextElement().openStream()));
            }
            return (byte[][])images.toArray((T[])new byte[images.size()][]);
        }

        private byte[] readFully(InputStream in) throws IOException {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            in.close();
            return baos.toByteArray();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return this.cl.equals(((ClassLoaderProxy)that).cl);
        }

        public int hashCode() {
            return this.cl.hashCode();
        }
    }

    static interface IClassLoader {
        public byte[] fetchJar(URL var1) throws IOException;

        public byte[] fetch(String var1) throws ClassNotFoundException;

        public byte[] getResource(String var1) throws IOException;

        public byte[][] getResources(String var1) throws IOException;
    }
}

