/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public final class Capability
implements Serializable {
    private final long mask;
    private static final long serialVersionUID = 1L;
    private static final long MASK_UNUSED1 = 1L;
    private static final long MASK_MULTI_CLASSLOADER = 2L;
    static final byte[] PREAMBLE;

    Capability(long mask) {
        this.mask = mask;
    }

    Capability() {
        this(2L);
    }

    public boolean supportsMultiClassLoaderRPC() {
        return (this.mask & 2L) != 0L;
    }

    void writePreamble(OutputStream os) throws IOException {
        os.write(PREAMBLE);
        ObjectOutputStream oos = new ObjectOutputStream(Channel.Mode.TEXT.wrap(os));
        oos.writeObject(this);
        oos.flush();
    }

    public static Capability read(InputStream is) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(Channel.Mode.TEXT.wrap(is));
            return (Capability)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw (Error)new NoClassDefFoundError(e.getMessage()).initCause(e);
        }
    }

    static {
        try {
            PREAMBLE = "<===[HUDSON REMOTING CAPACITY]===>".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

