/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Future;
import hudson.remoting.RequestAbortedException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public abstract class PingThread
extends Thread {
    private final Channel channel;
    private final long interval;
    private static final long TIME_OUT = 60000L;
    private static final Logger LOGGER = Logger.getLogger(PingThread.class.getName());

    public PingThread(Channel channel, long interval) {
        super("Ping thread for channel " + channel);
        this.channel = channel;
        this.interval = interval;
        this.setDaemon(true);
    }

    public PingThread(Channel channel) {
        this(channel, 300000L);
    }

    public void run() {
        try {
            block4: while (true) {
                long nextCheck = System.currentTimeMillis() + this.interval;
                this.ping();
                while (true) {
                    long diff;
                    if ((diff = nextCheck - System.currentTimeMillis()) <= 0L) continue block4;
                    Thread.sleep(diff);
                }
                break;
            }
        }
        catch (ChannelClosedException e) {
            LOGGER.fine(this.getName() + " is closed. Terminating");
        }
        catch (IOException e) {
            this.onDead();
        }
        catch (InterruptedException e) {
            LOGGER.fine(this.getName() + " is interrupted. Terminating");
        }
    }

    private void ping() throws IOException, InterruptedException {
        Future<Void> f = this.channel.callAsync(new Ping());
        try {
            f.get(60000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RequestAbortedException) {
                return;
            }
            this.onDead();
        }
        catch (TimeoutException e) {
            this.onDead();
        }
    }

    protected abstract void onDead();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Ping
    implements Callable<Void, IOException> {
        private static final long serialVersionUID = 1L;

        private Ping() {
        }

        @Override
        public Void call() throws IOException {
            return null;
        }
    }
}

