/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

abstract class PipeWindow {
    static final PipeWindow FAKE = new PipeWindow(){

        void increase(int delta) {
        }

        int peek() {
            return Integer.MAX_VALUE;
        }

        int get() throws InterruptedException {
            return Integer.MAX_VALUE;
        }

        void decrease(int delta) {
        }
    };

    PipeWindow() {
    }

    abstract void increase(int var1);

    abstract int peek();

    abstract int get() throws InterruptedException;

    abstract void decrease(int var1);

    static class Real
    extends PipeWindow {
        private int available;

        Real(int initialSize) {
            this.available = initialSize;
        }

        public synchronized void increase(int delta) {
            this.available += delta;
            this.notifyAll();
        }

        public synchronized int peek() {
            return this.available;
        }

        public synchronized int get() throws InterruptedException {
            while (this.available == 0) {
                this.wait();
            }
            return this.available;
        }

        public synchronized void decrease(int delta) {
            this.available -= delta;
            if (this.available < 0) {
                throw new AssertionError();
            }
        }
    }
}

