/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.PipeWindow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ProxyOutputStream
extends OutputStream {
    private Channel channel;
    private int oid;
    private PipeWindow window;
    private ByteArrayOutputStream tmp;
    private boolean closed;
    private static final Logger LOGGER = Logger.getLogger(ProxyOutputStream.class.getName());

    public ProxyOutputStream() {
    }

    public ProxyOutputStream(Channel channel, int oid) throws IOException {
        this.connect(channel, oid);
    }

    synchronized void connect(Channel channel, int oid) throws IOException {
        if (this.channel != null) {
            throw new IllegalStateException("Cannot connect twice");
        }
        if (oid == 0) {
            throw new IllegalArgumentException("oid=0");
        }
        this.channel = channel;
        this.oid = oid;
        this.window = channel.getPipeWindow(oid);
        if (this.tmp != null) {
            byte[] b = this.tmp.toByteArray();
            this.tmp = null;
            this._write(b);
        }
        if (this.closed) {
            this.doClose();
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is already closed");
        }
        this._write(b, off, len);
    }

    private void _write(byte[] b, int off, int len) throws IOException {
        if (off == 0 && len == b.length) {
            this._write(b);
        } else {
            byte[] buf = new byte[len];
            System.arraycopy(b, off, buf, 0, len);
            this._write(buf);
        }
    }

    public synchronized void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("stream is already closed");
        }
        this._write(b);
    }

    private void _write(byte[] b) throws IOException {
        if (this.channel == null) {
            if (this.tmp == null) {
                this.tmp = new ByteArrayOutputStream();
            }
            this.tmp.write(b);
        } else {
            int sendable;
            try {
                sendable = Math.min(this.window.get(), b.length);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
            if (sendable == b.length) {
                this.window.decrease(sendable);
                this.channel.send(new Chunk(this.oid, b));
            } else {
                this._write(b, 0, sendable);
                this._write(b, sendable, b.length - sendable);
            }
        }
    }

    public void flush() throws IOException {
        if (this.channel != null) {
            this.channel.send(new Flush(this.oid));
        }
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        if (this.channel != null) {
            this.doClose();
        }
    }

    private void doClose() throws IOException {
        this.channel.send(new EOF(this.oid));
        this.channel = null;
        this.oid = -1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.channel != null) {
            this.channel.send(new Unexport(this.oid));
            this.channel = null;
            this.oid = -1;
        }
    }

    private static class Ack
    extends Command {
        private final int oid;
        private final int size;
        private static final long serialVersionUID = 1L;

        private Ack(int oid, int size) {
            this.oid = oid;
            this.size = size;
        }

        protected void execute(Channel channel) {
            channel.getPipeWindow(this.oid).increase(this.size);
        }

        public String toString() {
            return "Pipe.Ack(" + this.oid + ',' + this.size + ")";
        }
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public EOF(int oid) {
            this.oid = oid;
        }

        protected void execute(final Channel channel) {
            final OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            channel.pipeWriter.submit(new Runnable(){

                public void run() {
                    channel.unexport(EOF.this.oid);
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        public String toString() {
            return "Pipe.EOF(" + this.oid + ")";
        }
    }

    private static class Unexport
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public Unexport(int oid) {
            this.oid = oid;
        }

        protected void execute(final Channel channel) {
            channel.pipeWriter.submit(new Runnable(){

                public void run() {
                    channel.unexport(Unexport.this.oid);
                }
            });
        }

        public String toString() {
            return "Pipe.Unexport(" + this.oid + ")";
        }
    }

    private static final class Flush
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public Flush(int oid) {
            super(false);
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            final OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            channel.pipeWriter.submit(new Runnable(){

                public void run() {
                    try {
                        os.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        public String toString() {
            return "Pipe.Flush(" + this.oid + ")";
        }
    }

    private static final class Chunk
    extends Command {
        private final int oid;
        private final byte[] buf;
        private static final long serialVersionUID = 1L;

        public Chunk(int oid, byte[] buf) {
            super(false);
            this.oid = oid;
            this.buf = buf;
        }

        protected void execute(final Channel channel) {
            final OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            channel.pipeWriter.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        os.write(Chunk.this.buf);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to write to stream", e);
                    }
                    finally {
                        if (channel.remoteCapability.supportsPipeThrottling()) {
                            try {
                                channel.send(new Ack(Chunk.this.oid, Chunk.this.buf.length));
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Failed to ack the stream", e);
                            }
                        }
                    }
                }
            });
        }

        public String toString() {
            return "Pipe.Chunk(" + this.oid + "," + this.buf.length + ")";
        }
    }
}

