/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import hudson.remoting.jnlp.Main;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    public Channel.Mode mode = Channel.Mode.BINARY;
    @Option(name="-ping")
    public boolean ping = true;
    @Option(name="-jnlpUrl", usage="instead of talking to the master via stdin/stdout, emulate a JNLP client by making a TCP connection to the master. Connection parameters are obtained by parsing the JNLP file.")
    public URL slaveJnlpURL = null;
    @Option(name="-jnlpCredentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP requests.")
    public String slaveJnlpCredentials = null;
    @Option(name="-tcp", usage="instead of talking to the master via stdin/stdout, listens to a random local port, write that port number to the given file, then wait for the master to connect to that port.")
    public File tcpPortFile = null;
    @Option(name="-auth", metaVar="user:pass", usage="If your Hudson is security-enabeld, specify a valid user name and password.")
    public String auth = null;
    public InetSocketAddress connectionTarget = null;
    public static final String VERSION = Launcher.computeVersion();

    @Option(name="-text", usage="encode communication with the master with base64. Useful for running slave over 8-bit unsafe protocol like telnet")
    public void setTextMode(boolean b) {
        this.mode = b ? Channel.Mode.TEXT : Channel.Mode.BINARY;
        System.out.println("Running in " + this.mode.name().toLowerCase(Locale.ENGLISH) + " mode");
    }

    @Option(name="-cp", aliases={"-classpath"}, metaVar="PATH", usage="add the given classpath elements to the system classloader.")
    public void addClasspath(String pathList) throws Exception {
        Method $addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        $addURL.setAccessible(true);
        for (String token : pathList.split(File.pathSeparator)) {
            $addURL.invoke((Object)ClassLoader.getSystemClassLoader(), new File(token).toURI().toURL());
        }
        System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparatorChar + pathList);
    }

    @Option(name="-connectTo", usage="make a TCP connection to the given host and port, then start communication.", metaVar="HOST:PORT")
    public void setConnectTo(String target) {
        String[] tokens = target.split(":");
        if (tokens.length != 2) {
            System.err.println("Illegal parameter: " + target);
            System.exit(1);
        }
        this.connectionTarget = new InetSocketAddress(tokens[0], (int)Integer.valueOf(tokens[1]));
    }

    @Option(name="-noCertificateCheck")
    public void setNoCertificateCheck(boolean _) throws NoSuchAlgorithmException, KeyManagementException {
        System.out.println("Skipping HTTPS certificate checks altoghether. Note that this is not secure at all.");
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new NoCheckTrustManager()}, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Launcher launcher = new Launcher();
        CmdLineParser parser = new CmdLineParser(launcher);
        try {
            parser.parseArgument(args);
            launcher.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar slave.jar [options...]");
            parser.printUsage(System.err);
            System.err.println();
        }
    }

    public void run() throws Exception {
        if (this.auth != null) {
            final int idx = this.auth.indexOf(58);
            if (idx < 0) {
                throw new CmdLineException(null, "No ':' in the -auth option");
            }
            Authenticator.setDefault(new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Launcher.this.auth.substring(0, idx), Launcher.this.auth.substring(idx + 1).toCharArray());
                }
            });
        }
        if (this.connectionTarget != null) {
            this.runAsTcpClient();
            System.exit(0);
        } else if (this.slaveJnlpURL != null) {
            List<String> jnlpArgs = this.parseJnlpArguments();
            try {
                Main._main(jnlpArgs.toArray(new String[jnlpArgs.size()]));
            }
            catch (CmdLineException e) {
                System.err.println("JNLP file " + this.slaveJnlpURL + " has invalid arguments: " + jnlpArgs);
                System.err.println("Most likely a configuration error in the master");
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else if (this.tcpPortFile != null) {
            this.runAsTcpServer();
            System.exit(0);
        } else {
            this.runWithStdinStdout();
            System.exit(0);
        }
    }

    public List<String> parseJnlpArguments() throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        while (true) {
            try {
                Document dom;
                HttpURLConnection http;
                URLConnection con = this.slaveJnlpURL.openConnection();
                if (con instanceof HttpURLConnection && this.slaveJnlpCredentials != null) {
                    http = (HttpURLConnection)con;
                    String userPassword = this.slaveJnlpCredentials;
                    String encoding = new BASE64Encoder().encode(userPassword.getBytes());
                    http.setRequestProperty("Authorization", "Basic " + encoding);
                }
                con.connect();
                if (con instanceof HttpURLConnection && (http = (HttpURLConnection)con).getResponseCode() >= 400) {
                    throw new IOException("Failed to load " + this.slaveJnlpURL + ": " + http.getResponseCode() + " " + http.getResponseMessage());
                }
                String contentType = con.getHeaderField("Content-Type");
                if (contentType == null || !contentType.startsWith("application/x-java-jnlp-file")) {
                    try {
                        dom = Launcher.loadDom(this.slaveJnlpURL, con);
                    }
                    catch (SAXException e) {
                        throw new IOException(this.slaveJnlpURL + " doesn't look like a JNLP file; content type was " + contentType);
                    }
                    catch (IOException e) {
                        throw new IOException(this.slaveJnlpURL + " doesn't look like a JNLP file; content type was " + contentType);
                    }
                } else {
                    dom = Launcher.loadDom(this.slaveJnlpURL, con);
                }
                NodeList argElements = dom.getElementsByTagName("argument");
                ArrayList<String> jnlpArgs = new ArrayList<String>();
                for (int i = 0; i < argElements.getLength(); ++i) {
                    jnlpArgs.add(argElements.item(i).getTextContent());
                }
                if (this.slaveJnlpCredentials != null) {
                    jnlpArgs.add("-credentials");
                    jnlpArgs.add(this.slaveJnlpCredentials);
                }
                jnlpArgs.add("-headless");
                return jnlpArgs;
            }
            catch (SSLHandshakeException e) {
                if (e.getMessage().contains("PKIX path building failed")) {
                    IOException x = new IOException("Failed to validate a server certificate. If you are using a self-signed certificate, you can use the -noCertificateCheck option to bypass this check.");
                    x.initCause(e);
                    throw x;
                }
                throw e;
            }
            catch (IOException e) {
                System.err.println("Failing to obtain " + this.slaveJnlpURL);
                e.printStackTrace(System.err);
                System.err.println("Waiting 10 seconds before retry");
                Thread.sleep(10000L);
                continue;
            }
            break;
        }
    }

    private static Document loadDom(URL slaveJnlpURL, URLConnection con) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return db.parse(con.getInputStream(), slaveJnlpURL.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsTcpServer() throws IOException, InterruptedException {
        Socket s;
        ServerSocket ss = new ServerSocket(0, 1);
        ss.setSoTimeout(30000);
        FileWriter w = new FileWriter(this.tcpPortFile);
        w.write(String.valueOf(ss.getLocalPort()));
        w.close();
        try {
            s = ss.accept();
            ss.close();
        }
        finally {
            this.tcpPortFile.delete();
        }
        this.runOnSocket(s);
    }

    private void runOnSocket(Socket s) throws IOException, InterruptedException {
        Launcher.main(new BufferedInputStream(new SocketInputStream(s)), new BufferedOutputStream(new SocketOutputStream(s)), this.mode, this.ping);
    }

    private void runAsTcpClient() throws IOException, InterruptedException {
        Socket s = new Socket(this.connectionTarget.getAddress(), this.connectionTarget.getPort());
        this.runOnSocket(s);
    }

    private void runWithStdinStdout() throws IOException, InterruptedException {
        Launcher.ttyCheck();
        if (Launcher.isWindows()) {
            new SecureRandom().nextBoolean();
        }
        PrintStream os = System.out;
        System.setOut(System.err);
        Launcher.main(System.in, os, this.mode, this.ping);
    }

    private static void ttyCheck() {
        try {
            Method m = System.class.getMethod("console", new Class[0]);
            Object console = m.invoke(null, new Object[0]);
            if (console != null) {
                System.out.println("WARNING: Are you running slave agent from an interactive console?\nIf so, you are probably using it incorrectly.\nSee http://hudson.gotdns.com/wiki/display/HUDSON/Launching+slave.jar+from+from+console");
            }
        }
        catch (LinkageError e) {
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void main(InputStream is, OutputStream os) throws IOException, InterruptedException {
        Launcher.main(is, os, Channel.Mode.BINARY);
    }

    public static void main(InputStream is, OutputStream os, Channel.Mode mode) throws IOException, InterruptedException {
        Launcher.main(is, os, mode, false);
    }

    public static void main(InputStream is, OutputStream os, Channel.Mode mode, boolean performPing) throws IOException, InterruptedException {
        ExecutorService executor = Executors.newCachedThreadPool();
        Channel channel = new Channel("channel", executor, mode, is, os);
        System.err.println("channel started");
        long timeout = 1000L * Long.parseLong(System.getProperty("hudson.remoting.Launcher.pingTimeoutSec", "240"));
        long interval = 1000L * Long.parseLong(System.getProperty("hudson.remoting.Launcher.pingIntervalSec", "600"));
        if (performPing && timeout > 0L && interval > 0L) {
            new PingThread(channel, timeout, interval){

                protected void onDead() {
                    System.err.println("Ping failed. Terminating");
                    System.exit(-1);
                }
            }.start();
        }
        channel.join();
        System.err.println("channel stopped");
    }

    public static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private static String computeVersion() {
        Properties props = new Properties();
        try {
            InputStream is = Launcher.class.getResourceAsStream("hudson-version.properties");
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props.getProperty("version", "?");
    }

    private static class NoCheckTrustManager
    implements X509TrustManager {
        private NoCheckTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

