/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.FastPipedInputStream;
import hudson.remoting.HexDump;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class FastPipedOutputStream
extends OutputStream {
    WeakReference<FastPipedInputStream> sink;
    private long written = 0L;
    private final Throwable allocatedAt = new Throwable();
    static final int TIMEOUT = Integer.getInteger(FastPipedOutputStream.class.getName() + ".timeout", 10000);

    public FastPipedOutputStream() {
    }

    public FastPipedOutputStream(FastPipedInputStream sink) throws IOException {
        this.connect(sink);
    }

    public FastPipedOutputStream(FastPipedInputStream sink, int bufferSize) throws IOException {
        this(sink);
    }

    private FastPipedInputStream sink() throws IOException {
        FastPipedInputStream s = (FastPipedInputStream)this.sink.get();
        if (s == null) {
            throw (IOException)new IOException("Reader side has already been abandoned").initCause(this.allocatedAt);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.sink == null) {
            throw new IOException("Unconnected pipe");
        }
        FastPipedInputStream s = this.sink();
        byte[] byArray = s.buffer;
        synchronized (s.buffer) {
            s.closed = new FastPipedInputStream.ClosedBy();
            this.flush();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void connect(FastPipedInputStream sink) throws IOException {
        if (this.sink != null) {
            throw new IOException("Pipe already connected");
        }
        this.sink = new WeakReference<FastPipedInputStream>(sink);
        sink.source = new WeakReference<FastPipedOutputStream>(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        FastPipedInputStream s = this.sink();
        byte[] byArray = s.buffer;
        synchronized (s.buffer) {
            s.buffer.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sink == null) {
            throw new IOException("Unconnected pipe");
        }
        while (len > 0) {
            FastPipedInputStream s = this.sink();
            if (s.closed != null) {
                throw (IOException)new IOException("Pipe is already closed").initCause(s.closed);
            }
            byte[] byArray = s.buffer;
            // MONITORENTER : s.buffer
            if (s.writePosition == s.readPosition && s.writeLaps > s.readLaps) {
                byte[] buf = s.buffer;
                s = null;
                Thread t = Thread.currentThread();
                String oldName = t.getName();
                t.setName("Blocking to write '" + HexDump.toHex(b, off, Math.min(len, 256)) + "' : " + oldName);
                try {
                    buf.wait(TIMEOUT);
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
                }
                finally {
                    t.setName(oldName);
                }
                // MONITOREXIT : byArray
                continue;
            }
            int amount = Math.min(len, (s.writePosition < s.readPosition ? s.readPosition : s.buffer.length) - s.writePosition);
            System.arraycopy(b, off, s.buffer, s.writePosition, amount);
            s.writePosition += amount;
            if (s.writePosition == s.buffer.length) {
                s.writePosition = 0;
                ++s.writeLaps;
            }
            off += amount;
            len -= amount;
            this.written += (long)amount;
            s.buffer.notifyAll();
            // MONITOREXIT : byArray
        }
    }
}

