/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class PipeWindow {
    protected Throwable dead;
    private static final Logger LOGGER = Logger.getLogger(PipeWindow.class.getName());

    PipeWindow() {
    }

    abstract void increase(int var1);

    abstract int peek();

    abstract int get() throws InterruptedException, IOException;

    abstract void decrease(int var1);

    void dead(Throwable cause) {
        this.dead = cause;
    }

    protected void checkDeath() throws IOException {
        if (this.dead != null) {
            throw (IOException)new IOException("Pipe is already closed").initCause(this.dead);
        }
    }

    static class Real
    extends PipeWindow {
        private int available;
        private long written;
        private long acked;
        private final int oid;
        private final Key key;

        Real(Key key, int initialSize) {
            this.key = key;
            this.oid = key.oid;
            this.available = initialSize;
        }

        public synchronized void increase(int delta) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("increase(%d,%d)->%d", this.oid, delta, delta + this.available));
            }
            this.available += delta;
            this.acked += (long)delta;
            this.notifyAll();
        }

        public synchronized int peek() {
            return this.available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int get() throws InterruptedException, IOException {
            this.checkDeath();
            Real real = this;
            synchronized (real) {
                if (this.available > 0) {
                    return this.available;
                }
                while (this.available <= 0) {
                    this.wait();
                    this.checkDeath();
                }
            }
            Thread.sleep(10L);
            real = this;
            synchronized (real) {
                return this.available;
            }
        }

        public synchronized void decrease(int delta) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("decrease(%d,%d)->%d", this.oid, delta, this.available - delta));
            }
            this.available -= delta;
            this.written += (long)delta;
        }
    }

    static final class Key {
        public final int oid;

        Key(int oid) {
            this.oid = oid;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.oid == ((Key)o).oid;
        }

        public int hashCode() {
            return this.oid;
        }
    }

    static class Fake
    extends PipeWindow {
        Fake() {
        }

        void increase(int delta) {
        }

        int peek() {
            return Integer.MAX_VALUE;
        }

        int get() throws InterruptedException, IOException {
            this.checkDeath();
            return Integer.MAX_VALUE;
        }

        void decrease(int delta) {
        }
    }
}

