/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.EngineListener;
import hudson.remoting.PingThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine
extends Thread {
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        public Thread newThread(final Runnable r) {
            return this.defaultFactory.newThread(new Runnable(){

                public void run() {
                    CURRENT.set(Engine.this);
                    r.run();
                }
            });
        }
    });
    public final EngineListener listener;
    private List<URL> candidateUrls;
    private URL hudsonUrl;
    private final String secretKey;
    public final String slaveName;
    private String credentials;
    private String tunnel;
    private boolean noReconnect;
    private String cookie;
    private static final ThreadLocal<Engine> CURRENT = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    public static final String GREETING_SUCCESS = "Welcome";

    public Engine(EngineListener listener, List<URL> hudsonUrls, String secretKey, String slaveName) {
        this.listener = listener;
        this.candidateUrls = hudsonUrls;
        this.secretKey = secretKey;
        this.slaveName = slaveName;
        if (this.candidateUrls.isEmpty()) {
            throw new IllegalArgumentException("No URLs given");
        }
    }

    public URL getHudsonUrl() {
        return this.hudsonUrl;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public void setCredentials(String creds) {
        this.credentials = creds;
    }

    public void setNoReconnect(boolean noReconnect) {
        this.noReconnect = noReconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean first = true;
            while (true) {
                if (first) {
                    first = false;
                } else if (this.noReconnect) {
                    return;
                }
                this.listener.status("Locating server among " + this.candidateUrls);
                Throwable firstError = null;
                String port = null;
                for (URL url : this.candidateUrls) {
                    URL salURL;
                    HttpURLConnection con;
                    String s = url.toExternalForm();
                    if (!s.endsWith("/")) {
                        s = s + '/';
                    }
                    if ((con = (HttpURLConnection)(salURL = new URL(s + "tcpSlaveAgentListener/")).openConnection()) instanceof HttpURLConnection && this.credentials != null) {
                        String encoding = new String(Base64.encodeBase64(this.credentials.getBytes()));
                        con.setRequestProperty("Authorization", "Basic " + encoding);
                    }
                    try {
                        con.setConnectTimeout(30000);
                        con.setReadTimeout(60000);
                        con.connect();
                    }
                    catch (IOException x) {
                        if (firstError == null) {
                            firstError = new IOException("Failed to connect to " + salURL + ": " + x.getMessage()).initCause(x);
                        }
                        con.disconnect();
                        continue;
                    }
                    try {
                        port = con.getHeaderField("X-Hudson-JNLP-Port");
                        if (con.getResponseCode() != 200) {
                            if (firstError != null) continue;
                            firstError = new Exception(salURL + " is invalid: " + con.getResponseCode() + " " + con.getResponseMessage());
                            continue;
                        }
                        if (port == null) {
                            if (firstError != null) continue;
                            firstError = new Exception(url + " is not Hudson");
                            continue;
                        }
                    }
                    finally {
                        con.disconnect();
                        continue;
                    }
                    this.hudsonUrl = url;
                    firstError = null;
                    this.candidateUrls = Collections.singletonList(this.hudsonUrl);
                    break;
                }
                if (firstError != null) {
                    this.listener.error(firstError);
                    return;
                }
                Socket s = this.connect(port);
                this.listener.status("Handshaking");
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                BufferedInputStream in = new BufferedInputStream(s.getInputStream());
                dos.writeUTF("Protocol:JNLP2-connect");
                Properties props = new Properties();
                props.put("Secret-Key", this.secretKey);
                props.put("Node-Name", this.slaveName);
                if (this.cookie != null) {
                    props.put("Cookie", this.cookie);
                }
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                props.store(o, null);
                dos.writeUTF(o.toString("UTF-8"));
                String greeting = Engine.readLine(in);
                if (greeting.startsWith("Unknown protocol")) {
                    LOGGER.info("The server didn't understand the v2 handshake. Falling back to v1 handshake");
                    s.close();
                    s = this.connect(port);
                    in = new BufferedInputStream(s.getInputStream());
                    dos = new DataOutputStream(s.getOutputStream());
                    dos.writeUTF("Protocol:JNLP-connect");
                    dos.writeUTF(this.secretKey);
                    dos.writeUTF(this.slaveName);
                    greeting = Engine.readLine(in);
                    if (!greeting.equals(GREETING_SUCCESS)) {
                        this.onConnectionRejected(greeting);
                        continue;
                    }
                } else if (greeting.equals(GREETING_SUCCESS)) {
                    Properties responses = this.readResponseHeaders(in);
                    this.cookie = responses.getProperty("Cookie");
                } else {
                    this.onConnectionRejected(greeting);
                    continue;
                }
                final Socket socket = s;
                final Channel channel = new Channel("channel", this.executor, in, new BufferedOutputStream(s.getOutputStream()));
                PingThread t = new PingThread(channel){

                    protected void onDead() {
                        try {
                            if (!channel.isInClosed()) {
                                LOGGER.info("Ping failed. Terminating the socket.");
                                socket.close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, "Failed to terminate the socket", e);
                        }
                    }
                };
                t.start();
                this.listener.status("Connected");
                channel.join();
                this.listener.status("Terminated");
                t.interrupt();
                this.listener.onDisconnect();
                if (this.noReconnect) {
                    return;
                }
                this.waitForServerToBack();
            }
        }
        catch (Throwable e) {
            this.listener.error(e);
            return;
        }
    }

    private void onConnectionRejected(String greeting) throws InterruptedException {
        this.listener.error(new Exception("The server rejected the connection: " + greeting));
        Thread.sleep(10000L);
    }

    private Properties readResponseHeaders(BufferedInputStream in) throws IOException {
        Properties response = new Properties();
        String line;
        while ((line = Engine.readLine(in)).length() != 0) {
            int idx = line.indexOf(58);
            response.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
        }
        return response;
    }

    private static String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int ch;
        while ((ch = in.read()) >= 0 && ch != 10) {
            baos.write(ch);
        }
        return baos.toString().trim();
    }

    private Socket connect(String port) throws IOException, InterruptedException {
        String host = this.hudsonUrl.getHost();
        if (this.tunnel != null) {
            String[] tokens = this.tunnel.split(":", 3);
            if (tokens.length != 2) {
                throw new IOException("Illegal tunneling parameter: " + this.tunnel);
            }
            if (tokens[0].length() > 0) {
                host = tokens[0];
            }
            if (tokens[1].length() > 0) {
                port = tokens[1];
            }
        }
        String msg = "Connecting to " + host + ':' + port;
        this.listener.status(msg);
        int retry = 1;
        while (true) {
            try {
                Socket s = new Socket(host, Integer.parseInt(port));
                s.setTcpNoDelay(true);
                s.setSoTimeout(1800000);
                return s;
            }
            catch (IOException e) {
                if (retry++ > 10) {
                    throw (IOException)new IOException("Failed to connect to " + host + ':' + port).initCause(e);
                }
                Thread.sleep(10000L);
                this.listener.status(msg + " (retrying:" + retry + ")", e);
                continue;
            }
            break;
        }
    }

    private void waitForServerToBack() throws InterruptedException {
        while (true) {
            Thread.sleep(10000L);
            try {
                HttpURLConnection con = (HttpURLConnection)new URL(this.hudsonUrl, "tcpSlaveAgentListener/").openConnection();
                con.connect();
                if (con.getResponseCode() != 200) continue;
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public static Engine current() {
        return CURRENT.get();
    }
}

