/*
 * Decompiled with CFR 0.152.
 */
package net.java.sezpoz;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.sezpoz.IndexError;
import net.java.sezpoz.SpaceIndexItem;
import net.java.sezpoz.impl.SerAnnotatedElement;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.URLClassSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpaceIndex<T extends Annotation, I>
implements Iterable<SpaceIndexItem<T, I>> {
    private static final Logger LOGGER = Logger.getLogger(SpaceIndex.class.getName());
    private final Class<T> annotation;
    private final Class<I> instanceType;
    private final ClassSpace space;

    public static <T extends Annotation, I> SpaceIndex<T, I> load(Class<T> annotation, Class<I> instanceType) throws IllegalArgumentException {
        return SpaceIndex.load(annotation, instanceType, (ClassSpace)new URLClassSpace(Thread.currentThread().getContextClassLoader()));
    }

    public static <T extends Annotation, I> SpaceIndex<T, I> load(Class<T> annotation, Class<I> instanceType, ClassSpace space) throws IllegalArgumentException {
        return new SpaceIndex<T, I>(annotation, instanceType, space);
    }

    private SpaceIndex(Class<T> annotation, Class<I> instance, ClassSpace space) {
        this.annotation = annotation;
        this.instanceType = instance;
        this.space = space;
    }

    @Override
    public Iterator<SpaceIndexItem<T, I>> iterator() {
        return new LazyIndexIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LazyIndexIterator
    implements Iterator<SpaceIndexItem<T, I>> {
        private Enumeration<URL> resources;
        private ObjectInputStream ois;
        private URL resource;
        private SpaceIndexItem<T, I> next;
        private boolean end;
        private final Set<String> loadedMembers = new HashSet<String>();

        public LazyIndexIterator() {
            if (LOGGER.isLoggable(Level.FINE)) {
                String urls = SpaceIndex.this.space instanceof URLClassSpace ? " " + Arrays.toString(((URLClassSpace)SpaceIndex.this.space).getURLs()) : "";
                LOGGER.log(Level.FINE, "Searching for indices of {0} in {1}{2}", new Object[]{SpaceIndex.this.annotation, SpaceIndex.this.space, urls});
            }
        }

        private void peek() throws IndexError {
            try {
                int iteration = 0;
                while (true) {
                    SerAnnotatedElement el;
                    if (iteration == 9999) {
                        LOGGER.log(Level.WARNING, "possible endless loop getting index for {0} from {1}", new Object[]{SpaceIndex.this.annotation, SpaceIndex.this.space});
                    }
                    if (this.next != null || this.end) {
                        return;
                    }
                    if (this.ois == null) {
                        if (this.resources == null) {
                            this.resources = SpaceIndex.this.space.findEntries("META-INF/annotations/", SpaceIndex.this.annotation.getName(), false);
                        }
                        if (!this.resources.hasMoreElements()) {
                            this.end = true;
                            return;
                        }
                        this.resource = this.resources.nextElement();
                        LOGGER.log(Level.FINE, "Loading index from {0}", this.resource);
                        this.ois = new ObjectInputStream(this.resource.openStream());
                    }
                    if ((el = (SerAnnotatedElement)this.ois.readObject()) == null) {
                        this.ois.close();
                        this.ois = null;
                    } else {
                        String memberName;
                        String string = el.isMethod ? String.valueOf(el.className) + '#' + el.memberName + "()" : (memberName = el.memberName != null ? String.valueOf(el.className) + '#' + el.memberName : el.className);
                        if (this.loadedMembers.add(memberName)) {
                            this.next = new SpaceIndexItem(el, SpaceIndex.this.annotation, SpaceIndex.this.instanceType, SpaceIndex.this.space, this.resource);
                            break;
                        }
                        LOGGER.log(Level.FINE, "Already loaded index item {0}", el);
                    }
                    ++iteration;
                }
            }
            catch (Exception x) {
                if (this.ois != null) {
                    try {
                        this.ois.close();
                    }
                    catch (IOException x2) {
                        LOGGER.log(Level.WARNING, null, x2);
                    }
                }
                throw new IndexError((Throwable)x);
            }
        }

        @Override
        public boolean hasNext() {
            this.peek();
            return !this.end;
        }

        @Override
        public SpaceIndexItem<T, I> next() {
            this.peek();
            if (!this.end) {
                assert (this.next != null);
                SpaceIndexItem _next = this.next;
                this.next = null;
                return _next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

