/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal.extension;

import hudson.Extension;
import hudson.ExtensionComponent;
import java.lang.annotation.Annotation;
import org.hudsonci.inject.Priority;
import org.sonatype.inject.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothieComponent<T>
extends ExtensionComponent<T> {
    private final BeanEntry<Annotation, T> bean;
    private final T value;
    private final double priority;
    public static final double DEFAULT_PRIORITY = 0.0;

    public SmoothieComponent(BeanEntry<Annotation, T> bean) {
        super(null);
        this.bean = bean;
        this.value = bean.getValue();
        Double p = SmoothieComponent.priorityOf(this.value);
        this.priority = p != null ? p : 0.0;
    }

    public BeanEntry<Annotation, T> getBean() {
        return this.bean;
    }

    public Class<?> getType() {
        return this.getBean().getImplementationClass();
    }

    public T getInstance() {
        return this.value;
    }

    public double getPriority() {
        return this.priority;
    }

    public double ordinal() {
        return this.getPriority();
    }

    public String toString() {
        return "SmoothieComponent{type=" + this.getType() + ", priority=" + this.getPriority() + ", bean=" + this.bean + '}';
    }

    public static Double priorityOf(Object component) {
        if (component == null) {
            return null;
        }
        return SmoothieComponent.priorityOf(component.getClass());
    }

    public static Double priorityOf(Class<?> type) {
        if (type != null) {
            Priority priority = type.getAnnotation(Priority.class);
            if (priority != null) {
                return priority.value();
            }
            Extension ext = type.getAnnotation(Extension.class);
            if (ext != null) {
                return ext.ordinal();
            }
        }
        return null;
    }

    public static Double priorityOf(Annotation annotation) {
        if (annotation != null) {
            if (annotation instanceof Priority) {
                return ((Priority)annotation).value();
            }
            if (annotation instanceof Extension) {
                return ((Extension)annotation).ordinal();
            }
        }
        return null;
    }
}

