/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal.extension;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import hudson.ExtensionComponent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.inject.SmoothieContainer;
import org.hudsonci.inject.internal.extension.ExtensionLocator;
import org.hudsonci.inject.internal.extension.SmoothieComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.inject.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class SmoothieExtensionLocator
implements ExtensionLocator {
    private static final Logger log = LoggerFactory.getLogger(SmoothieExtensionLocator.class);
    private final SmoothieContainer container;

    @Inject
    public SmoothieExtensionLocator(SmoothieContainer container) {
        this.container = (SmoothieContainer)Preconditions.checkNotNull((Object)container);
    }

    @Override
    public <T> List<ExtensionComponent<T>> locate(Class<T> type) {
        Preconditions.checkNotNull(type);
        if (log.isDebugEnabled()) {
            log.debug("Finding extensions: {}", (Object)type.getName());
        }
        ArrayList<ExtensionComponent<T>> components = new ArrayList<ExtensionComponent<T>>();
        try {
            Iterable items = this.container.locate(Key.get(type));
            for (BeanEntry item : items) {
                SmoothieComponent component = new SmoothieComponent(item);
                log.debug("Found: {}", component);
                if (component.getInstance() == null) continue;
                components.add(component);
            }
            if (log.isDebugEnabled()) {
                log.debug("Found {} {} components", (Object)components.size(), (Object)type.getName());
            }
        }
        catch (Exception e) {
            log.error("Extension discovery failed", (Throwable)e);
        }
        if (log.isDebugEnabled() && components.isEmpty()) {
            log.debug("No components of type '{}' discovered", (Object)type.getName());
        }
        return components;
    }
}

