/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.injecto.internal;

import com.google.inject.Key;
import org.hudsonci.inject.Smoothie;
import org.hudsonci.inject.injecto.Injectomatic;
import org.hudsonci.inject.injecto.InjectomaticAware;
import org.hudsonci.inject.internal.OID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectomaticAspectHelper {
    private static final Logger log = LoggerFactory.getLogger(InjectomaticAspectHelper.class);
    private static boolean enabled = false;
    private static Injectomatic injecto;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean flag) {
        enabled = flag;
        log.debug("Aspect-based injection {}", (Object)(flag ? "enabled" : "disabled"));
    }

    private static Injectomatic getInjectomatic() {
        if (injecto == null) {
            injecto = (Injectomatic)Smoothie.getContainer().get(Key.get(Injectomatic.class));
        }
        return injecto;
    }

    static void inject(Object object) {
        assert (object != null);
        if (!enabled) {
            log.warn("Injection disabled; ignoring request to inject: {}", (Object)OID.get(object));
            return;
        }
        InjectomaticAspectHelper.getInjectomatic().inject(object);
    }

    static void install(Object object) {
        assert (object != null);
        if (!enabled) {
            log.warn("Injection disabled; ignoring request to install injectomatic: {}", (Object)OID.get(object));
            return;
        }
        ((InjectomaticAware)object).setInjectomatic(InjectomaticAspectHelper.getInjectomatic());
    }
}

