/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hudsonci.inject.SmoothieContainer;
import org.hudsonci.inject.internal.HudsonModule;
import org.hudsonci.inject.internal.OID;
import org.hudsonci.inject.internal.extension.ExtensionLocator;
import org.hudsonci.inject.internal.extension.ExtensionModule;
import org.hudsonci.inject.internal.extension.SmoothieExtensionLocator;
import org.hudsonci.inject.internal.plugin.PluginClassLoader;
import org.hudsonci.inject.internal.plugin.SmoothiePluginStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.locators.DefaultBeanLocator;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.inject.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothieContainerImpl
implements SmoothieContainer {
    private static final Logger log = LoggerFactory.getLogger(SmoothieContainerImpl.class);
    private final MutableBeanLocator locator = new DefaultBeanLocator();
    private final Injector root;
    private final Map<PluginWrapper, Injector> injectors = new HashMap<PluginWrapper, Injector>();

    public SmoothieContainerImpl(Module ... modules) {
        this.root = this.createInjector(new Module[]{new BootModule(modules)});
    }

    private Injector createInjector(Module ... modules) {
        assert (modules != null);
        Injector injector = Guice.createInjector((Module[])new Module[]{new WireModule(modules)});
        if (log.isTraceEnabled()) {
            log.trace("Created injector: {} w/bindings:", (Object)OID.get(injector));
            for (Map.Entry entry : injector.getAllBindings().entrySet()) {
                log.trace("  {} -> {}", entry.getKey(), entry.getValue());
            }
        }
        return injector;
    }

    public Injector rootInjector() {
        return this.root;
    }

    @Override
    public void register(PluginWrapper plugin) {
        assert (plugin != null);
        if (log.isTraceEnabled()) {
            log.trace("Registering plugin: {}", (Object)plugin.getShortName());
        }
        if (this.injectors.containsKey(plugin)) {
            throw new IllegalStateException("Plugin already registered");
        }
        Injector injector = this.createInjector(new Module[]{new PluginModule(plugin)});
        this.injectors.put(plugin, injector);
    }

    @Override
    public Injector injector(PluginWrapper plugin) {
        assert (plugin != null);
        Injector injector = this.injectors.get(plugin);
        if (injector == null) {
            throw new IllegalStateException("Plugin not registered");
        }
        return injector;
    }

    @Override
    public <Q extends Annotation, T> Iterable<BeanEntry<Q, T>> locate(Key<T> key) {
        return this.locator.locate(key);
    }

    @Override
    public <T> T get(Key<T> key) {
        Iterator iter = this.locate(key).iterator();
        assert (iter != null);
        if (iter.hasNext()) {
            BeanEntry bean = iter.next();
            log.debug("Found: {}", bean);
            Object value = bean.getValue();
            if (log.isDebugEnabled() && iter.hasNext()) {
                log.debug("More than one instance bound for key: {}", key);
                while (iter.hasNext()) {
                    log.debug("  {}", iter.next());
                }
            }
            return (T)value;
        }
        throw new RuntimeException("No object bound for key: " + key);
    }

    private class BootModule
    extends CommonModule {
        private BootModule(Module[] modules) {
            super(modules);
        }

        protected void configure() {
            this.bind(PluginStrategy.class).annotatedWith((Annotation)Names.named((String)"default")).to(SmoothiePluginStrategy.class);
            this.bind(ExtensionLocator.class).annotatedWith((Annotation)Names.named((String)"default")).to(SmoothieExtensionLocator.class);
            super.configure();
        }
    }

    private class CommonModule
    extends AbstractModule {
        private final Module[] modules;

        private CommonModule(Module[] modules) {
            assert (modules != null);
            this.modules = modules;
        }

        private CommonModule() {
            this(new Module[0]);
        }

        protected void configure() {
            this.bind(MutableBeanLocator.class).toInstance((Object)SmoothieContainerImpl.this.locator);
            this.bind(SmoothieContainer.class).toInstance((Object)SmoothieContainerImpl.this);
            this.install((Module)new HudsonModule());
            Module[] moduleArray = this.modules;
            int n = this.modules.length;
            int n2 = 0;
            while (n2 < n) {
                Module module = moduleArray[n2];
                this.install(module);
                ++n2;
            }
        }
    }

    private class PluginModule
    extends CommonModule {
        private final PluginWrapper plugin;

        private PluginModule(PluginWrapper plugin) {
            assert (plugin != null);
            this.plugin = plugin;
        }

        protected void configure() {
            ClassSpace space = this.createClassSpace();
            this.install(new ExtensionModule(space));
            super.configure();
        }

        private ClassSpace createClassSpace() {
            URLClassSpace space;
            if (this.plugin.classLoader instanceof PluginClassLoader) {
                PluginClassLoader cl = (PluginClassLoader)this.plugin.classLoader;
                space = new URLClassSpace((ClassLoader)cl, cl.getURLs());
            } else {
                log.warn("Expected plugin to have PluginClassLoader; instead found: {}", (Object)this.plugin.classLoader.getClass().getName());
                space = new URLClassSpace(this.plugin.classLoader);
            }
            return space;
        }
    }
}

